/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.CheckPointerService;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreFileRequest;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyRequestHandler;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamingProtocol;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.messaging.StoreCopyRequest;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.JobSchedulerAdapter;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class StoreCopyRequestHandlerTest {
    private static final StoreId STORE_ID_MISMATCHING = new StoreId(1L, 1L, 1L, 1L);
    private static final StoreId STORE_ID_MATCHING = new StoreId(1L, 2L, 3L, 4L);
    private final DefaultFileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();
    private final NeoStoreDataSource neoStoreDataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
    private final FakeCheckPointer checkPointer = new FakeCheckPointer();
    private EmbeddedChannel embeddedChannel;
    private CatchupServerProtocol catchupServerProtocol;
    private JobScheduler jobScheduler = new FakeSingleThreadedJobScheduler();
    private CheckPointerService checkPointerService = new CheckPointerService(() -> this.checkPointer, this.jobScheduler, Group.CHECKPOINT);

    @Before
    public void setup() {
        this.catchupServerProtocol = new CatchupServerProtocol();
        this.catchupServerProtocol.expect((Enum)CatchupServerProtocol.State.GET_STORE_FILE);
        NiceStoreCopyRequestHandler storeCopyRequestHandler = new NiceStoreCopyRequestHandler(this.catchupServerProtocol, () -> this.neoStoreDataSource, new StoreFileStreamingProtocol(), (FileSystemAbstraction)this.fileSystemAbstraction, (LogProvider)NullLogProvider.getInstance());
        Dependencies dependencies = new Dependencies();
        Mockito.when((Object)this.neoStoreDataSource.getStoreId()).thenReturn((Object)new org.neo4j.storageengine.api.StoreId(1L, 2L, 5L, 3L, 4L));
        Mockito.when((Object)this.neoStoreDataSource.getDependencyResolver()).thenReturn((Object)dependencies);
        Mockito.when((Object)this.neoStoreDataSource.getDatabaseLayout()).thenReturn((Object)DatabaseLayout.of((File)new File(".")));
        this.embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{storeCopyRequestHandler});
    }

    @Test
    public void shouldGiveProperErrorOnStoreIdMismatch() {
        this.embeddedChannel.writeInbound(new Object[]{new GetStoreFileRequest(STORE_ID_MISMATCHING, new File("some-file"), 1L)});
        Assert.assertEquals((Object)ResponseMessageType.STORE_COPY_FINISHED, (Object)this.embeddedChannel.readOutbound());
        StoreCopyFinishedResponse expectedResponse = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH);
        Assert.assertEquals((Object)expectedResponse, (Object)this.embeddedChannel.readOutbound());
        Assert.assertTrue((boolean)this.catchupServerProtocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE));
    }

    @Test
    public void shouldGiveProperErrorOnTxBehind() {
        this.embeddedChannel.writeInbound(new Object[]{new GetStoreFileRequest(STORE_ID_MATCHING, new File("some-file"), 2L)});
        Assert.assertEquals((Object)ResponseMessageType.STORE_COPY_FINISHED, (Object)this.embeddedChannel.readOutbound());
        StoreCopyFinishedResponse expectedResponse = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.E_TOO_FAR_BEHIND);
        Assert.assertEquals((Object)expectedResponse, (Object)this.embeddedChannel.readOutbound());
        Assert.assertTrue((boolean)this.catchupServerProtocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE));
    }

    @Test
    public void shouldResetProtocolAndGiveErrorOnUncheckedException() {
        Mockito.when((Object)this.neoStoreDataSource.getStoreId()).thenThrow(new Throwable[]{new IllegalStateException()});
        try {
            this.embeddedChannel.writeInbound(new Object[]{new GetStoreFileRequest(STORE_ID_MATCHING, new File("some-file"), 1L)});
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)ResponseMessageType.STORE_COPY_FINISHED, (Object)this.embeddedChannel.readOutbound());
        StoreCopyFinishedResponse expectedResponse = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.E_UNKNOWN);
        Assert.assertEquals((Object)expectedResponse, (Object)this.embeddedChannel.readOutbound());
        Assert.assertTrue((boolean)this.catchupServerProtocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE));
    }

    @Test
    public void shoulResetProtocolAndGiveErrorIfFilesThrowException() {
        EmbeddedChannel alternativeChannel = new EmbeddedChannel(new ChannelHandler[]{new EvilStoreCopyRequestHandler(this.catchupServerProtocol, () -> this.neoStoreDataSource, new StoreFileStreamingProtocol(), (FileSystemAbstraction)this.fileSystemAbstraction, (LogProvider)NullLogProvider.getInstance())});
        try {
            alternativeChannel.writeInbound(new Object[]{new GetStoreFileRequest(STORE_ID_MATCHING, new File("some-file"), 1L)});
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)ResponseMessageType.STORE_COPY_FINISHED, (Object)alternativeChannel.readOutbound());
        StoreCopyFinishedResponse expectedResponse = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.E_UNKNOWN);
        Assert.assertEquals((Object)expectedResponse, (Object)alternativeChannel.readOutbound());
        Assert.assertTrue((boolean)this.catchupServerProtocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE));
    }

    @Test
    public void transactionsTooFarBehindStartCheckpointAsynchronously() {
        this.checkPointer._tryCheckPoint = Optional.empty();
        try {
            this.embeddedChannel.writeInbound(new Object[]{new GetStoreFileRequest(STORE_ID_MATCHING, new File("some-file"), 123L)});
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"FakeCheckPointer", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)ResponseMessageType.STORE_COPY_FINISHED, (Object)this.embeddedChannel.readOutbound());
        Assert.assertEquals((long)1L, (long)this.checkPointer.invocationCounter.get());
        Assert.assertEquals((long)1L, (long)this.checkPointer.failCounter.get());
    }

    static class FakeSingleThreadedJobScheduler
    extends JobSchedulerAdapter {
        FakeSingleThreadedJobScheduler() {
        }

        public JobHandle schedule(Group group, Runnable job) {
            job.run();
            return (JobHandle)Mockito.mock(JobHandle.class);
        }
    }

    private class FakeCheckPointer
    implements CheckPointer {
        Optional<Long> _checkPointIfNeeded = Optional.of(1L);
        Optional<Long> _tryCheckPoint = Optional.of(1L);
        Optional<Long> _forceCheckPoint = Optional.of(1L);
        Optional<Long> _lastCheckPointedTransactionId = Optional.of(1L);
        Supplier<RuntimeException> exceptionIfEmpty = () -> new RuntimeException("FakeCheckPointer");
        AtomicInteger invocationCounter = new AtomicInteger();
        AtomicInteger failCounter = new AtomicInteger();

        private FakeCheckPointer() {
        }

        public long checkPointIfNeeded(TriggerInfo triggerInfo) {
            this.incrementInvocationCounter(this._checkPointIfNeeded);
            return this._checkPointIfNeeded.orElseThrow(this.exceptionIfEmpty);
        }

        public long tryCheckPoint(TriggerInfo triggerInfo) {
            this.incrementInvocationCounter(this._tryCheckPoint);
            return this._tryCheckPoint.orElseThrow(this.exceptionIfEmpty);
        }

        public long forceCheckPoint(TriggerInfo triggerInfo) {
            this.incrementInvocationCounter(this._forceCheckPoint);
            return this._forceCheckPoint.orElseThrow(this.exceptionIfEmpty);
        }

        public long lastCheckPointedTransactionId() {
            this.incrementInvocationCounter(this._lastCheckPointedTransactionId);
            return this._lastCheckPointedTransactionId.orElseThrow(this.exceptionIfEmpty);
        }

        private void incrementInvocationCounter(Optional<Long> variable) {
            if (variable.isPresent()) {
                this.invocationCounter.getAndIncrement();
                return;
            }
            this.failCounter.getAndIncrement();
        }
    }

    private class EvilStoreCopyRequestHandler
    extends StoreCopyRequestHandler<StoreCopyRequest> {
        private EvilStoreCopyRequestHandler(CatchupServerProtocol protocol, Supplier<NeoStoreDataSource> dataSource, StoreFileStreamingProtocol storeFileStreamingProtocol, FileSystemAbstraction fs, LogProvider logProvider) {
            super(protocol, dataSource, StoreCopyRequestHandlerTest.this.checkPointerService, storeFileStreamingProtocol, fs, logProvider);
        }

        ResourceIterator<StoreFileMetadata> files(StoreCopyRequest request, NeoStoreDataSource neoStoreDataSource) {
            throw new IllegalStateException("I am evil");
        }
    }

    private class NiceStoreCopyRequestHandler
    extends StoreCopyRequestHandler<StoreCopyRequest> {
        private NiceStoreCopyRequestHandler(CatchupServerProtocol protocol, Supplier<NeoStoreDataSource> dataSource, StoreFileStreamingProtocol storeFileStreamingProtocol, FileSystemAbstraction fs, LogProvider logProvider) {
            super(protocol, dataSource, StoreCopyRequestHandlerTest.this.checkPointerService, storeFileStreamingProtocol, fs, logProvider);
        }

        ResourceIterator<StoreFileMetadata> files(StoreCopyRequest request, NeoStoreDataSource neoStoreDataSource) {
            return Iterators.emptyResourceIterator();
        }
    }
}

