/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequest;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequestDecoder;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequestEncoder;
import org.neo4j.causalclustering.identity.StoreId;

public class PrepareStoreCopyRequestMarshalTest {
    EmbeddedChannel embeddedChannel;

    @Before
    public void setup() {
        this.embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{new PrepareStoreCopyRequestEncoder(), new PrepareStoreCopyRequestDecoder()});
    }

    @Test
    public void storeIdIsTransmitted() {
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
        PrepareStoreCopyRequest prepareStoreCopyRequest = new PrepareStoreCopyRequest(storeId);
        PrepareStoreCopyRequestMarshalTest.sendToChannel(prepareStoreCopyRequest, this.embeddedChannel);
        PrepareStoreCopyRequest prepareStoreCopyRequestRead = (PrepareStoreCopyRequest)this.embeddedChannel.readInbound();
        Assert.assertEquals((Object)prepareStoreCopyRequest.getStoreId(), (Object)prepareStoreCopyRequestRead.getStoreId());
    }

    public static <E> void sendToChannel(E e, EmbeddedChannel embeddedChannel) {
        embeddedChannel.writeOutbound(new Object[]{e});
        ByteBuf object = (ByteBuf)embeddedChannel.readOutbound();
        embeddedChannel.writeInbound(new Object[]{object});
    }
}

