/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.time.Clock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;

public class LocalDatabaseTest {
    @Test
    public void availabilityGuardRaisedOnCreation() {
        DatabaseAvailabilityGuard guard = LocalDatabaseTest.newAvailabilityGuard();
        Assert.assertTrue((boolean)guard.isAvailable());
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase((AvailabilityGuard)guard);
        Assert.assertNotNull((Object)localDatabase);
        LocalDatabaseTest.assertDatabaseIsStoppedAndUnavailable(guard);
    }

    @Test
    public void availabilityGuardDroppedOnStart() {
        DatabaseAvailabilityGuard guard = LocalDatabaseTest.newAvailabilityGuard();
        Assert.assertTrue((boolean)guard.isAvailable());
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase((AvailabilityGuard)guard);
        Assert.assertFalse((boolean)guard.isAvailable());
        localDatabase.start();
        Assert.assertTrue((boolean)guard.isAvailable());
    }

    @Test
    public void availabilityGuardRaisedOnStop() throws Throwable {
        DatabaseAvailabilityGuard guard = LocalDatabaseTest.newAvailabilityGuard();
        Assert.assertTrue((boolean)guard.isAvailable());
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase((AvailabilityGuard)guard);
        Assert.assertFalse((boolean)guard.isAvailable());
        localDatabase.start();
        Assert.assertTrue((boolean)guard.isAvailable());
        localDatabase.stop();
        LocalDatabaseTest.assertDatabaseIsStoppedAndUnavailable(guard);
    }

    @Test
    public void availabilityGuardRaisedOnStopForStoreCopy() throws Throwable {
        DatabaseAvailabilityGuard guard = LocalDatabaseTest.newAvailabilityGuard();
        Assert.assertTrue((boolean)guard.isAvailable());
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase((AvailabilityGuard)guard);
        Assert.assertFalse((boolean)guard.isAvailable());
        localDatabase.start();
        Assert.assertTrue((boolean)guard.isAvailable());
        localDatabase.stopForStoreCopy();
        LocalDatabaseTest.assertDatabaseIsStoppedForStoreCopyAndUnavailable(guard);
    }

    @Test
    public void availabilityGuardRaisedBeforeDataSourceManagerIsStopped() throws Throwable {
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        DataSourceManager dataSourceManager = (DataSourceManager)Mockito.mock(DataSourceManager.class);
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase(guard, dataSourceManager);
        localDatabase.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{guard, dataSourceManager});
        ((AvailabilityGuard)inOrder.verify((Object)guard, Mockito.times((int)2))).require((AvailabilityRequirement)ArgumentMatchers.any());
        ((DataSourceManager)inOrder.verify((Object)dataSourceManager)).stop();
    }

    @Test
    public void availabilityGuardRaisedBeforeDataSourceManagerIsStoppedForStoreCopy() throws Throwable {
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        DataSourceManager dataSourceManager = (DataSourceManager)Mockito.mock(DataSourceManager.class);
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase(guard, dataSourceManager);
        localDatabase.stopForStoreCopy();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{guard, dataSourceManager});
        ((AvailabilityGuard)inOrder.verify((Object)guard, Mockito.times((int)2))).require((AvailabilityRequirement)ArgumentMatchers.any());
        ((DataSourceManager)inOrder.verify((Object)dataSourceManager)).stop();
    }

    @Test
    public void doNotRestartServicesIfAlreadyStarted() {
        DataSourceManager dataSourceManager = (DataSourceManager)Mockito.mock(DataSourceManager.class);
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase((AvailabilityGuard)LocalDatabaseTest.newAvailabilityGuard(), dataSourceManager);
        localDatabase.start();
        ((DataSourceManager)Mockito.verify((Object)dataSourceManager)).start();
        Mockito.reset((Object[])new DataSourceManager[]{dataSourceManager});
        localDatabase.start();
        localDatabase.start();
        ((DataSourceManager)Mockito.verify((Object)dataSourceManager, (VerificationMode)Mockito.never())).start();
    }

    private static LocalDatabase newLocalDatabase(AvailabilityGuard databaseAvailabilityGuard) {
        return LocalDatabaseTest.newLocalDatabase(databaseAvailabilityGuard, (DataSourceManager)Mockito.mock(DataSourceManager.class));
    }

    private static LocalDatabase newLocalDatabase(AvailabilityGuard databaseAvailabilityGuard, DataSourceManager dataSourceManager) {
        return new LocalDatabase((DatabaseLayout)Mockito.mock(DatabaseLayout.class), (StoreFiles)Mockito.mock(StoreFiles.class), (LogFiles)Mockito.mock(LogFiles.class), dataSourceManager, () -> (DatabaseHealth)Mockito.mock(DatabaseHealth.class), databaseAvailabilityGuard, (LogProvider)NullLogProvider.getInstance());
    }

    private static DatabaseAvailabilityGuard newAvailabilityGuard() {
        return new DatabaseAvailabilityGuard("graph.db", Clock.systemUTC(), (Log)NullLog.getInstance());
    }

    private static void assertDatabaseIsStoppedAndUnavailable(DatabaseAvailabilityGuard guard) {
        Assert.assertFalse((boolean)guard.isAvailable());
        Assert.assertThat((Object)guard.describeWhoIsBlocking(), (Matcher)Matchers.containsString((String)"Database is stopped"));
    }

    private static void assertDatabaseIsStoppedForStoreCopyAndUnavailable(DatabaseAvailabilityGuard guard) {
        Assert.assertFalse((boolean)guard.isAvailable());
        Assert.assertThat((Object)guard.describeWhoIsBlocking(), (Matcher)Matchers.containsString((String)"Database is stopped to copy store"));
    }
}

