/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupAddressResolutionException;
import org.neo4j.causalclustering.catchup.UpstreamStrategyAddressSupplier;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionStrategy;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategySelector;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class UpstreamStrategyAddressSupplierTest {
    private MemberId defaultMember = new MemberId(UUID.randomUUID());
    private MemberId firstMember = new MemberId(UUID.randomUUID());
    private MemberId secondMember = new MemberId(UUID.randomUUID());
    private AdvertisedSocketAddress defaultAddress = new AdvertisedSocketAddress("Default", 123);
    private AdvertisedSocketAddress firstAddress = new AdvertisedSocketAddress("First", 456);
    private AdvertisedSocketAddress secondAddress = new AdvertisedSocketAddress("Second", 789);
    private TopologyService topologyService = (TopologyService)Mockito.mock(TopologyService.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        Mockito.when((Object)this.topologyService.findCatchupAddress((MemberId)ArgumentMatchers.eq((Object)this.defaultMember))).thenReturn(Optional.of(this.defaultAddress));
        Mockito.when((Object)this.topologyService.findCatchupAddress((MemberId)ArgumentMatchers.eq((Object)this.firstMember))).thenReturn(Optional.of(this.firstAddress));
        Mockito.when((Object)this.topologyService.findCatchupAddress((MemberId)ArgumentMatchers.eq((Object)this.secondMember))).thenReturn(Optional.of(this.secondAddress));
    }

    @Test
    public void selectionPrioritiesAreKept() throws CatchupAddressResolutionException {
        UpstreamDatabaseStrategySelector upstreamDatabaseStrategySelector = new UpstreamDatabaseStrategySelector((UpstreamDatabaseSelectionStrategy)new CountedSelectionStrategy(this.defaultMember, 5), Arrays.asList(new UpstreamDatabaseSelectionStrategy[]{new CountedSelectionStrategy(this.firstMember, 1), new CountedSelectionStrategy(this.secondMember, 1)}), (LogProvider)NullLogProvider.getInstance());
        UpstreamStrategyAddressSupplier upstreamStrategyAddressSupplier = new UpstreamStrategyAddressSupplier(upstreamDatabaseStrategySelector, this.topologyService);
        AdvertisedSocketAddress firstResult = upstreamStrategyAddressSupplier.get();
        AdvertisedSocketAddress secondResult = upstreamStrategyAddressSupplier.get();
        AdvertisedSocketAddress thirdResult = upstreamStrategyAddressSupplier.get();
        Assert.assertEquals((Object)this.firstAddress, (Object)firstResult);
        Assert.assertEquals((Object)this.secondAddress, (Object)secondResult);
        Assert.assertEquals((Object)this.defaultAddress, (Object)thirdResult);
    }

    @Test
    public void exceptionWhenStrategiesFail() throws CatchupAddressResolutionException {
        UpstreamDatabaseStrategySelector upstreamDatabaseStrategySelector = new UpstreamDatabaseStrategySelector((UpstreamDatabaseSelectionStrategy)new CountedSelectionStrategy(this.defaultMember, 0));
        UpstreamStrategyAddressSupplier upstreamStrategyAddressSupplier = new UpstreamStrategyAddressSupplier(upstreamDatabaseStrategySelector, this.topologyService);
        this.expectedException.expect(CatchupAddressResolutionException.class);
        upstreamStrategyAddressSupplier.get();
    }

    private class CountedSelectionStrategy
    extends UpstreamDatabaseSelectionStrategy {
        MemberId upstreamDatabase;
        private int numberOfIterations;

        CountedSelectionStrategy(MemberId upstreamDatabase, int numberOfIterations) {
            super(CountedSelectionStrategy.class.getName(), new String[0]);
            this.upstreamDatabase = upstreamDatabase;
            this.numberOfIterations = numberOfIterations;
        }

        public Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException {
            MemberId consumed = this.upstreamDatabase;
            --this.numberOfIterations;
            if (this.numberOfIterations < 0) {
                this.upstreamDatabase = null;
            }
            return Optional.ofNullable(consumed);
        }

        public int hashCode() {
            return super.hashCode() + this.upstreamDatabase.hashCode() * 17 + 31 * this.numberOfIterations;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CountedSelectionStrategy)) {
                return false;
            }
            CountedSelectionStrategy other = (CountedSelectionStrategy)((Object)o);
            return this.upstreamDatabase.equals((Object)other.upstreamDatabase) && this.numberOfIterations == other.numberOfIterations;
        }
    }
}

