/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.causalclustering.core.state.ClusterStateDirectory;
import org.neo4j.causalclustering.core.state.ClusterStateException;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.commandline.dbms.StoreLockChecker;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Validators;

public class UnbindFromClusterCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withDatabase();
    private Path homeDir;
    private Path configDir;
    private OutsideWorld outsideWorld;

    UnbindFromClusterCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    static Arguments arguments() {
        return arguments;
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir, String databaseName) {
        return Config.fromFile((Path)configDir.resolve("neo4j.conf")).withSetting(GraphDatabaseSettings.active_database, databaseName).withHome(homeDir).build();
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        try {
            Config config = UnbindFromClusterCommand.loadNeo4jConfig(this.homeDir, this.configDir, arguments.parse(args).get("database"));
            File dataDirectory = (File)config.get(GraphDatabaseSettings.data_directory);
            Path pathToSpecificDatabase = ((File)config.get(GraphDatabaseSettings.database_path)).toPath();
            boolean hasDatabase = true;
            try {
                Validators.CONTAINS_EXISTING_DATABASE.validate((Object)pathToSpecificDatabase.toFile());
            }
            catch (IllegalArgumentException ignored) {
                hasDatabase = false;
            }
            if (hasDatabase) {
                this.confirmTargetDirectoryIsWritable(pathToSpecificDatabase);
            }
            ClusterStateDirectory clusterStateDirectory = new ClusterStateDirectory(dataDirectory);
            clusterStateDirectory.initialize(this.outsideWorld.fileSystem());
            this.deleteClusterStateIn(clusterStateDirectory.get().toPath());
        }
        catch (StoreLockException e) {
            throw new CommandFailed("Database is currently locked. Please shutdown Neo4j.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        catch (IOException | ClusterStateException | CannotWriteException | UnbindFailureException e) {
            throw new CommandFailed(e.getMessage(), e);
        }
    }

    private void confirmTargetDirectoryIsWritable(Path pathToSpecificDatabase) throws CannotWriteException, IOException {
        Closeable ignored = StoreLockChecker.check((Path)pathToSpecificDatabase);
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
    }

    private void deleteClusterStateIn(Path target) throws UnbindFailureException {
        try {
            FileUtils.deleteRecursively((File)target.toFile());
        }
        catch (IOException e) {
            throw new UnbindFailureException(e);
        }
    }

    private class UnbindFailureException
    extends Exception {
        UnbindFailureException(Exception e) {
            super(e);
        }
    }
}

