/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.routing.load_balancing.filters.IdentityFilter;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.FilteringPolicy;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.Policy;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;

public class Policies {
    public static final String POLICY_KEY = "policy";
    static final String DEFAULT_POLICY_NAME = "default";
    static final Policy DEFAULT_POLICY = new FilteringPolicy(IdentityFilter.as());
    private final Map<String, Policy> policies = new HashMap<String, Policy>();
    private final Log log;

    Policies(Log log) {
        this.log = log;
    }

    void addPolicy(String policyName, Policy policy) {
        Policy oldPolicy = this.policies.putIfAbsent(policyName, policy);
        if (oldPolicy != null) {
            this.log.error(String.format("Policy name conflict for '%s'.", policyName));
        }
    }

    Policy selectFor(Map<String, String> context) throws ProcedureException {
        String policyName = context.get(POLICY_KEY);
        if (policyName == null) {
            return this.defaultPolicy();
        }
        Policy selectedPolicy = this.policies.get(policyName);
        if (selectedPolicy == null) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, String.format("Policy definition for '%s' could not be found.", policyName), new Object[0]);
        }
        return selectedPolicy;
    }

    private Policy defaultPolicy() {
        Policy registeredDefault = this.policies.get(DEFAULT_POLICY_NAME);
        return registeredDefault != null ? registeredDefault : DEFAULT_POLICY;
    }
}

