/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StatusCode {
    SUCCESS(0),
    ONGOING(1),
    FAILURE(-1);

    private final int codeValue;
    private static AtomicReference<Map<Integer, StatusCode>> codeMap;

    private StatusCode(int codeValue) {
        this.codeValue = codeValue;
    }

    public int codeValue() {
        return this.codeValue;
    }

    public static Optional<StatusCode> fromCodeValue(int codeValue) {
        Map<Integer, StatusCode> map = codeMap.get();
        if (map == null) {
            map = Stream.of(StatusCode.values()).collect(Collectors.toMap(StatusCode::codeValue, Function.identity()));
            codeMap.compareAndSet(null, map);
        }
        return Optional.ofNullable(map.get(codeValue));
    }

    static {
        codeMap = new AtomicReference();
    }
}

