/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.BaseProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverRequest;
import org.neo4j.helpers.collection.Pair;

public class ServerMessageDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int messageCode = in.readInt();
        switch (messageCode) {
            case 877610318: {
                String magic = StringMarshal.unmarshal(in);
                out.add(new InitialMagicMessage(magic));
                return;
            }
            case 1: {
                ApplicationProtocolRequest applicationProtocolRequest = this.decodeProtocolRequest(ApplicationProtocolRequest::new, in, ByteBuf::readInt);
                out.add(applicationProtocolRequest);
                return;
            }
            case 2: {
                ModifierProtocolRequest modifierProtocolRequest = this.decodeProtocolRequest(ModifierProtocolRequest::new, in, StringMarshal::unmarshal);
                out.add(modifierProtocolRequest);
                return;
            }
            case 3: {
                String protocolName = StringMarshal.unmarshal(in);
                int version = in.readInt();
                int numberOfModifierProtocols = in.readInt();
                List<Pair<String, String>> modifierProtocols = Stream.generate(() -> Pair.of((Object)StringMarshal.unmarshal(in), (Object)StringMarshal.unmarshal(in))).limit(numberOfModifierProtocols).collect(Collectors.toList());
                out.add(new SwitchOverRequest(protocolName, version, modifierProtocols));
                return;
            }
        }
    }

    private <U extends Comparable<U>, T extends BaseProtocolRequest<U>> T decodeProtocolRequest(BiFunction<String, Set<U>, T> constructor, ByteBuf in, Function<ByteBuf, U> versionDecoder) {
        String protocolName = StringMarshal.unmarshal(in);
        int versionArrayLength = in.readInt();
        Set versions = Stream.generate(() -> (Comparable)versionDecoder.apply(in)).limit(versionArrayLength).collect(Collectors.toSet());
        return (T)((BaseProtocolRequest)constructor.apply(protocolName, versions));
    }
}

