/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import java.util.concurrent.RejectedExecutionException;
import org.neo4j.causalclustering.messaging.SimpleNettyChannel;
import org.neo4j.causalclustering.net.ChildInitializer;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.ServerNettyPipelineBuilder;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.NettyHandshakeServer;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.ServerHandshakeFinishedEvent;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageDecoder;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageEncoder;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class HandshakeServerInitializer
implements ChildInitializer {
    private final Log log;
    private final ApplicationProtocolRepository applicationProtocolRepository;
    private final ModifierProtocolRepository modifierProtocolRepository;
    private final ProtocolInstallerRepository<ProtocolInstaller.Orientation.Server> protocolInstallerRepository;
    private final NettyPipelineBuilderFactory pipelineBuilderFactory;

    public HandshakeServerInitializer(ApplicationProtocolRepository applicationProtocolRepository, ModifierProtocolRepository modifierProtocolRepository, ProtocolInstallerRepository<ProtocolInstaller.Orientation.Server> protocolInstallerRepository, NettyPipelineBuilderFactory pipelineBuilderFactory, LogProvider logProvider) {
        this.log = logProvider.getLog(this.getClass());
        this.applicationProtocolRepository = applicationProtocolRepository;
        this.modifierProtocolRepository = modifierProtocolRepository;
        this.protocolInstallerRepository = protocolInstallerRepository;
        this.pipelineBuilderFactory = pipelineBuilderFactory;
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        this.log.info("Installing handshake server local %s remote %s", new Object[]{ch.localAddress(), ch.remoteAddress()});
        ((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)this.pipelineBuilderFactory.server((Channel)ch, this.log).addFraming().add("handshake_server_encoder", new ChannelHandler[]{new ServerMessageEncoder()})).add("handshake_server_decoder", new ChannelHandler[]{new ServerMessageDecoder()})).add("handshake_server", new ChannelHandler[]{this.createHandshakeServer(ch)})).install();
    }

    private NettyHandshakeServer createHandshakeServer(SocketChannel channel) {
        HandshakeServer handshakeServer = new HandshakeServer(this.applicationProtocolRepository, this.modifierProtocolRepository, new SimpleNettyChannel((Channel)channel, this.log));
        handshakeServer.protocolStackFuture().whenComplete((protocolStack, failure) -> this.onHandshakeComplete((ProtocolStack)protocolStack, channel, (Throwable)failure));
        channel.closeFuture().addListener(f -> {
            try {
                channel.parent().pipeline().fireUserEventTriggered((Object)new ServerHandshakeFinishedEvent.Closed(this.toSocketAddress(channel)));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        });
        return new NettyHandshakeServer(handshakeServer);
    }

    private void onHandshakeComplete(ProtocolStack protocolStack, SocketChannel channel, Throwable failure) {
        if (failure != null) {
            this.log.error("Error when negotiating protocol stack", failure);
            return;
        }
        try {
            this.protocolInstallerRepository.installerFor(protocolStack).install((Channel)channel);
            channel.parent().pipeline().fireUserEventTriggered((Object)new ServerHandshakeFinishedEvent.Created(this.toSocketAddress(channel), protocolStack));
        }
        catch (Throwable t) {
            this.log.error("Error installing protocol stack", t);
        }
    }

    private SocketAddress toSocketAddress(SocketChannel channel) {
        InetSocketAddress inetSocketAddress = channel.remoteAddress();
        return new SocketAddress(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
    }
}

