/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.messaging.Channel;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.ServerHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageHandler;
import org.neo4j.causalclustering.protocol.handshake.StatusCode;
import org.neo4j.causalclustering.protocol.handshake.SupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverRequest;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverResponse;
import org.neo4j.stream.Streams;

public class HandshakeServer
implements ServerMessageHandler {
    private final Channel channel;
    private final ApplicationProtocolRepository applicationProtocolRepository;
    private final ModifierProtocolRepository modifierProtocolRepository;
    private final SupportedProtocols<Integer, Protocol.ApplicationProtocol> supportedApplicationProtocol;
    private final ProtocolStack.Builder protocolStackBuilder = ProtocolStack.builder();
    private final CompletableFuture<ProtocolStack> protocolStackFuture = new CompletableFuture();
    private boolean magicReceived;
    private boolean initialised;

    HandshakeServer(ApplicationProtocolRepository applicationProtocolRepository, ModifierProtocolRepository modifierProtocolRepository, Channel channel) {
        this.channel = channel;
        this.applicationProtocolRepository = applicationProtocolRepository;
        this.modifierProtocolRepository = modifierProtocolRepository;
        this.supportedApplicationProtocol = applicationProtocolRepository.supportedProtocol();
    }

    public void init() {
        this.channel.writeAndFlush(InitialMagicMessage.instance());
        this.initialised = true;
    }

    private void ensureMagic() {
        if (!this.magicReceived) {
            this.decline("No magic value received");
            throw new IllegalStateException("Magic value not received.");
        }
        if (!this.initialised) {
            this.init();
        }
    }

    @Override
    public void handle(InitialMagicMessage magicMessage) {
        if (!magicMessage.isCorrectMagic()) {
            this.decline("Incorrect magic value received");
        }
        this.magicReceived = true;
    }

    @Override
    public void handle(ApplicationProtocolRequest request) {
        this.ensureMagic();
        if (!request.protocolName().equals(this.supportedApplicationProtocol.identifier().canonicalName())) {
            ApplicationProtocolResponse response = ApplicationProtocolResponse.NO_PROTOCOL;
            this.channel.writeAndFlush(response);
            this.decline(String.format("Requested protocol %s not supported", request.protocolName()));
        } else {
            Optional selected = this.applicationProtocolRepository.select(request.protocolName(), this.supportedVersionsFor(request));
            if (selected.isPresent()) {
                Protocol.ApplicationProtocol selectedProtocol = (Protocol.ApplicationProtocol)selected.get();
                this.protocolStackBuilder.application(selectedProtocol);
                ApplicationProtocolResponse response = new ApplicationProtocolResponse(StatusCode.SUCCESS, selectedProtocol.category(), (Integer)selectedProtocol.implementation());
                this.channel.writeAndFlush(response);
            } else {
                ApplicationProtocolResponse response = ApplicationProtocolResponse.NO_PROTOCOL;
                this.channel.writeAndFlush(response);
                this.decline(String.format("Do not support requested protocol %s versions %s", request.protocolName(), request.versions()));
            }
        }
    }

    @Override
    public void handle(ModifierProtocolRequest modifierProtocolRequest) {
        ModifierProtocolResponse response;
        this.ensureMagic();
        Optional selected = this.modifierProtocolRepository.select(modifierProtocolRequest.protocolName(), this.supportedVersionsFor(modifierProtocolRequest));
        if (selected.isPresent()) {
            Protocol.ModifierProtocol modifierProtocol = (Protocol.ModifierProtocol)selected.get();
            this.protocolStackBuilder.modifier(modifierProtocol);
            response = new ModifierProtocolResponse(StatusCode.SUCCESS, modifierProtocol.category(), (String)modifierProtocol.implementation());
        } else {
            response = ModifierProtocolResponse.failure(modifierProtocolRequest.protocolName());
        }
        this.channel.writeAndFlush(response);
    }

    @Override
    public void handle(SwitchOverRequest switchOverRequest) {
        this.ensureMagic();
        ProtocolStack protocolStack = this.protocolStackBuilder.build();
        Optional switchOverProtocol = this.applicationProtocolRepository.select(switchOverRequest.protocolName(), switchOverRequest.version());
        List switchOverModifiers = switchOverRequest.modifierProtocols().stream().map(pair -> this.modifierProtocolRepository.select((String)pair.first(), (Comparable)pair.other())).flatMap(Streams::ofOptional).collect(Collectors.toList());
        if (!switchOverProtocol.isPresent()) {
            this.channel.writeAndFlush(SwitchOverResponse.FAILURE);
            this.decline(String.format("Cannot switch to protocol %s version %d", switchOverRequest.protocolName(), switchOverRequest.version()));
        } else if (protocolStack.applicationProtocol() == null) {
            this.channel.writeAndFlush(SwitchOverResponse.FAILURE);
            this.decline(String.format("Attempted to switch to protocol %s version %d before negotiation complete", switchOverRequest.protocolName(), switchOverRequest.version()));
        } else if (!((Protocol.ApplicationProtocol)switchOverProtocol.get()).equals(protocolStack.applicationProtocol())) {
            this.channel.writeAndFlush(SwitchOverResponse.FAILURE);
            this.decline(String.format("Switch over mismatch: requested %s version %s but negotiated %s version %s", switchOverRequest.protocolName(), switchOverRequest.version(), protocolStack.applicationProtocol().category(), protocolStack.applicationProtocol().implementation()));
        } else if (!switchOverModifiers.equals(protocolStack.modifierProtocols())) {
            this.channel.writeAndFlush(SwitchOverResponse.FAILURE);
            this.decline(String.format("Switch over mismatch: requested modifiers %s but negotiated %s", switchOverRequest.modifierProtocols(), protocolStack.modifierProtocols()));
        } else {
            SwitchOverResponse response = new SwitchOverResponse(StatusCode.SUCCESS);
            this.channel.writeAndFlush(response);
            this.protocolStackFuture.complete(protocolStack);
        }
    }

    private Set<String> supportedVersionsFor(ModifierProtocolRequest request) {
        return this.modifierProtocolRepository.supportedProtocolFor(request.protocolName()).map(supported -> supported.mutuallySupportedVersionsFor(request.versions())).orElse(Collections.emptySet());
    }

    private Set<Integer> supportedVersionsFor(ApplicationProtocolRequest request) {
        return this.supportedApplicationProtocol.mutuallySupportedVersionsFor(request.versions());
    }

    private void decline(String message) {
        this.channel.dispose();
        this.protocolStackFuture.completeExceptionally(new ServerHandshakeException(message, this.protocolStackBuilder));
    }

    CompletableFuture<ProtocolStack> protocolStackFuture() {
        return this.protocolStackFuture;
    }
}

