/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.messaging.Channel;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ClientHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.ClientMessageHandler;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ProtocolSelection;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.StatusCode;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverRequest;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverResponse;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.stream.Streams;

public class HandshakeClient
implements ClientMessageHandler {
    private Channel channel;
    private ApplicationProtocolRepository applicationProtocolRepository;
    private ApplicationSupportedProtocols supportedApplicationProtocol;
    private ModifierProtocolRepository modifierProtocolRepository;
    private Collection<ModifierSupportedProtocols> supportedModifierProtocols;
    private Protocol.ApplicationProtocol negotiatedApplicationProtocol;
    private List<Pair<String, Optional<Protocol.ModifierProtocol>>> negotiatedModifierProtocols;
    private ProtocolStack protocolStack;
    private CompletableFuture<ProtocolStack> future = new CompletableFuture();
    private boolean magicReceived;

    public CompletableFuture<ProtocolStack> initiate(Channel channel, ApplicationProtocolRepository applicationProtocolRepository, ModifierProtocolRepository modifierProtocolRepository) {
        this.channel = channel;
        this.applicationProtocolRepository = applicationProtocolRepository;
        this.supportedApplicationProtocol = applicationProtocolRepository.supportedProtocol();
        this.modifierProtocolRepository = modifierProtocolRepository;
        this.supportedModifierProtocols = modifierProtocolRepository.supportedProtocols();
        this.negotiatedModifierProtocols = new ArrayList<Pair<String, Optional<Protocol.ModifierProtocol>>>(this.supportedModifierProtocols.size());
        channel.write(InitialMagicMessage.instance());
        this.sendProtocolRequests(channel, this.supportedApplicationProtocol, this.supportedModifierProtocols);
        return this.future;
    }

    private void sendProtocolRequests(Channel channel, ApplicationSupportedProtocols applicationProtocols, Collection<ModifierSupportedProtocols> supportedModifierProtocols) {
        supportedModifierProtocols.forEach(modifierProtocol -> {
            ProtocolSelection protocolSelection = this.modifierProtocolRepository.getAll(modifierProtocol.identifier(), modifierProtocol.versions());
            channel.write(new ModifierProtocolRequest(protocolSelection.identifier(), protocolSelection.versions()));
        });
        ProtocolSelection applicationProtocolSelection = this.applicationProtocolRepository.getAll(applicationProtocols.identifier(), applicationProtocols.versions());
        channel.writeAndFlush(new ApplicationProtocolRequest(applicationProtocolSelection.identifier(), applicationProtocolSelection.versions()));
    }

    private void ensureMagic() {
        if (!this.magicReceived) {
            this.decline("Magic value not received.");
            throw new IllegalStateException("Magic value not received.");
        }
    }

    @Override
    public void handle(InitialMagicMessage magicMessage) {
        if (!magicMessage.isCorrectMagic()) {
            this.decline("Incorrect magic value received");
        }
        this.magicReceived = true;
    }

    @Override
    public void handle(ApplicationProtocolResponse applicationProtocolResponse) {
        this.ensureMagic();
        if (applicationProtocolResponse.statusCode() != StatusCode.SUCCESS) {
            this.decline("Unsuccessful application protocol response");
            return;
        }
        Optional protocol = this.applicationProtocolRepository.select(applicationProtocolResponse.protocolName(), applicationProtocolResponse.version());
        if (!protocol.isPresent()) {
            ProtocolSelection knownApplicationProtocolVersions = this.applicationProtocolRepository.getAll(this.supportedApplicationProtocol.identifier(), this.supportedApplicationProtocol.versions());
            this.decline(String.format("Mismatch of application protocols between client and server: Server protocol %s version %d: Client protocol %s versions %s", applicationProtocolResponse.protocolName(), applicationProtocolResponse.version(), knownApplicationProtocolVersions.identifier(), knownApplicationProtocolVersions.versions()));
        } else {
            this.negotiatedApplicationProtocol = (Protocol.ApplicationProtocol)protocol.get();
            this.sendSwitchOverRequestIfReady();
        }
    }

    @Override
    public void handle(ModifierProtocolResponse modifierProtocolResponse) {
        this.ensureMagic();
        if (modifierProtocolResponse.statusCode() == StatusCode.SUCCESS) {
            Optional selectedModifierProtocol = this.modifierProtocolRepository.select(modifierProtocolResponse.protocolName(), modifierProtocolResponse.version());
            this.negotiatedModifierProtocols.add((Pair<String, Optional<Protocol.ModifierProtocol>>)Pair.of((Object)modifierProtocolResponse.protocolName(), selectedModifierProtocol));
        } else {
            this.negotiatedModifierProtocols.add((Pair<String, Optional<Protocol.ModifierProtocol>>)Pair.of((Object)modifierProtocolResponse.protocolName(), Optional.empty()));
        }
        this.sendSwitchOverRequestIfReady();
    }

    private void sendSwitchOverRequestIfReady() {
        if (this.negotiatedApplicationProtocol != null && this.negotiatedModifierProtocols.size() == this.supportedModifierProtocols.size()) {
            List<Protocol.ModifierProtocol> agreedModifierProtocols = this.negotiatedModifierProtocols.stream().map(Pair::other).flatMap(Streams::ofOptional).collect(Collectors.toList());
            this.protocolStack = new ProtocolStack(this.negotiatedApplicationProtocol, agreedModifierProtocols);
            List<Pair<String, String>> switchOverModifierProtocols = agreedModifierProtocols.stream().map(protocol -> Pair.of((Object)protocol.category(), protocol.implementation())).collect(Collectors.toList());
            this.channel.writeAndFlush(new SwitchOverRequest(this.negotiatedApplicationProtocol.category(), (Integer)this.negotiatedApplicationProtocol.implementation(), switchOverModifierProtocols));
        }
    }

    @Override
    public void handle(SwitchOverResponse response) {
        this.ensureMagic();
        if (this.protocolStack == null) {
            this.decline("Attempted to switch over when protocol stack not established");
        } else if (response.status() != StatusCode.SUCCESS) {
            this.decline("Server failed to switch over");
        } else {
            this.future.complete(this.protocolStack);
        }
    }

    boolean failIfNotDone(String message) {
        if (!this.future.isDone()) {
            this.decline(message);
            return true;
        }
        return false;
    }

    private void decline(String message) {
        this.future.completeExceptionally(new ClientHandshakeException(message, this.negotiatedApplicationProtocol, this.negotiatedModifierProtocols));
    }
}

