/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Objects;
import org.neo4j.causalclustering.protocol.handshake.ClientMessage;
import org.neo4j.causalclustering.protocol.handshake.StatusCode;

public abstract class BaseProtocolResponse<IMPL extends Comparable<IMPL>>
implements ClientMessage {
    private final StatusCode statusCode;
    private final String protocolName;
    private final IMPL version;

    BaseProtocolResponse(StatusCode statusCode, String protocolName, IMPL version) {
        this.statusCode = statusCode;
        this.protocolName = protocolName;
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseProtocolResponse that = (BaseProtocolResponse)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.protocolName, that.protocolName);
    }

    public int hashCode() {
        return Objects.hash(this.protocolName, this.version);
    }

    public StatusCode statusCode() {
        return this.statusCode;
    }

    public String protocolName() {
        return this.protocolName;
    }

    public IMPL version() {
        return this.version;
    }

    public String toString() {
        return "BaseProtocolResponse{statusCode=" + (Object)((Object)this.statusCode) + ", protocolName='" + this.protocolName + '\'' + ", version=" + this.version + '}';
    }
}

