/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public interface Protocol<IMPL extends Comparable<IMPL>> {
    public String category();

    public IMPL implementation();

    public static <IMPL extends Comparable<IMPL>, T extends Protocol<IMPL>> Optional<T> find(T[] values, Category<T> category, IMPL implementation, Function<IMPL, IMPL> normalise) {
        return Stream.of(values).filter(protocol -> Objects.equals(protocol.category(), category.canonicalName())).filter(protocol -> Objects.equals(normalise.apply(protocol.implementation()), normalise.apply(implementation))).findFirst();
    }

    public static enum ModifierProtocols implements ModifierProtocol
    {
        COMPRESSION_GZIP(ModifierProtocolCategory.COMPRESSION, "Gzip"),
        COMPRESSION_SNAPPY(ModifierProtocolCategory.COMPRESSION, "Snappy"),
        COMPRESSION_SNAPPY_VALIDATING(ModifierProtocolCategory.COMPRESSION, "Snappy_validating"),
        COMPRESSION_LZ4(ModifierProtocolCategory.COMPRESSION, "LZ4"),
        COMPRESSION_LZ4_HIGH_COMPRESSION(ModifierProtocolCategory.COMPRESSION, "LZ4_high_compression"),
        COMPRESSION_LZ4_VALIDATING(ModifierProtocolCategory.COMPRESSION, "LZ_validating"),
        COMPRESSION_LZ4_HIGH_COMPRESSION_VALIDATING(ModifierProtocolCategory.COMPRESSION, "LZ4_high_compression_validating");

        private final String friendlyName;
        private final ModifierProtocolCategory identifier;

        private ModifierProtocols(ModifierProtocolCategory identifier, String friendlyName) {
            this.identifier = identifier;
            this.friendlyName = friendlyName;
        }

        @Override
        public String implementation() {
            return this.friendlyName;
        }

        @Override
        public String category() {
            return this.identifier.canonicalName();
        }

        public static Optional<ModifierProtocol> find(ModifierProtocolCategory category, String friendlyName) {
            return Protocol.find((Protocol[])ModifierProtocols.values(), (Category)category, (Comparable)((Object)friendlyName), String::toLowerCase);
        }

        public static class Implementations {
            public static final String GZIP = "Gzip";
            public static final String SNAPPY = "Snappy";
            public static final String SNAPPY_VALIDATING = "Snappy_validating";
            public static final String LZ4 = "LZ4";
            public static final String LZ4_HIGH_COMPRESSION = "LZ4_high_compression";
            public static final String LZ_VALIDATING = "LZ_validating";
            public static final String LZ4_HIGH_COMPRESSION_VALIDATING = "LZ4_high_compression_validating";
        }
    }

    public static enum ModifierProtocolCategory implements Category<ModifierProtocol>
    {
        COMPRESSION,
        GRATUITOUS_OBFUSCATION;


        @Override
        public String canonicalName() {
            return this.name().toLowerCase();
        }
    }

    public static interface ModifierProtocol
    extends Protocol<String> {
    }

    public static enum ApplicationProtocols implements ApplicationProtocol
    {
        RAFT_1(ApplicationProtocolCategory.RAFT, 1),
        RAFT_2(ApplicationProtocolCategory.RAFT, 2),
        CATCHUP_1(ApplicationProtocolCategory.CATCHUP, 1);

        private final Integer version;
        private final ApplicationProtocolCategory identifier;

        private ApplicationProtocols(ApplicationProtocolCategory identifier, int version) {
            this.identifier = identifier;
            this.version = version;
        }

        @Override
        public String category() {
            return this.identifier.canonicalName();
        }

        @Override
        public Integer implementation() {
            return this.version;
        }

        public static Optional<ApplicationProtocol> find(ApplicationProtocolCategory category, Integer version) {
            return Protocol.find((Protocol[])ApplicationProtocols.values(), (Category)category, (Comparable)version, Function.identity());
        }
    }

    public static enum ApplicationProtocolCategory implements Category<ApplicationProtocol>
    {
        RAFT,
        CATCHUP;


        @Override
        public String canonicalName() {
            return this.name().toLowerCase();
        }
    }

    public static interface ApplicationProtocol
    extends Protocol<Integer> {
    }

    public static interface Category<T extends Protocol> {
        public String canonicalName();
    }
}

