/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.Lz4FrameDecoder;
import io.netty.handler.codec.compression.Lz4FrameEncoder;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import io.netty.handler.codec.compression.SnappyFrameEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilder;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;

public interface ModifierProtocolInstaller<O extends ProtocolInstaller.Orientation> {
    public static final List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Server>> serverCompressionInstallers = Arrays.asList(new SnappyServer(), new SnappyValidatingServer(), new LZ4Server(), new LZ4ValidatingServer(), new GzipServer());
    public static final List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Client>> clientCompressionInstallers = Arrays.asList(new SnappyClient(), new LZ4Client(), new LZ4HighCompressionClient(), new GzipClient());
    public static final List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Client>> allClientInstallers = clientCompressionInstallers;
    public static final List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Server>> allServerInstallers = serverCompressionInstallers;

    public Collection<Protocol.ModifierProtocol> protocols();

    public <BUILDER extends NettyPipelineBuilder<O, BUILDER>> void apply(NettyPipelineBuilder<O, BUILDER> var1);

    public static class GzipServer
    extends BaseServerModifier {
        GzipServer() {
            super("zlib_decoder", JdkZlibDecoder::new, Protocol.ModifierProtocols.COMPRESSION_GZIP);
        }
    }

    public static class GzipClient
    extends BaseClientModifier {
        GzipClient() {
            super("zlib_encoder", JdkZlibEncoder::new, Protocol.ModifierProtocols.COMPRESSION_GZIP);
        }
    }

    public static class LZ4ValidatingServer
    extends BaseServerModifier {
        LZ4ValidatingServer() {
            super("lz4_decoder", () -> new Lz4FrameDecoder(true), Protocol.ModifierProtocols.COMPRESSION_LZ4_VALIDATING, Protocol.ModifierProtocols.COMPRESSION_LZ4_HIGH_COMPRESSION_VALIDATING);
        }
    }

    public static class LZ4Server
    extends BaseServerModifier {
        LZ4Server() {
            super("lz4_decoder", Lz4FrameDecoder::new, Protocol.ModifierProtocols.COMPRESSION_LZ4, Protocol.ModifierProtocols.COMPRESSION_LZ4_HIGH_COMPRESSION);
        }
    }

    public static class LZ4HighCompressionClient
    extends BaseClientModifier {
        LZ4HighCompressionClient() {
            super("lz4_encoder", () -> new Lz4FrameEncoder(true), Protocol.ModifierProtocols.COMPRESSION_LZ4_HIGH_COMPRESSION, Protocol.ModifierProtocols.COMPRESSION_LZ4_HIGH_COMPRESSION_VALIDATING);
        }
    }

    public static class LZ4Client
    extends BaseClientModifier {
        LZ4Client() {
            super("lz4_encoder", Lz4FrameEncoder::new, Protocol.ModifierProtocols.COMPRESSION_LZ4, Protocol.ModifierProtocols.COMPRESSION_LZ4_VALIDATING);
        }
    }

    public static class SnappyValidatingServer
    extends BaseServerModifier {
        SnappyValidatingServer() {
            super("snappy_validating_decoder", () -> new SnappyFrameDecoder(true), Protocol.ModifierProtocols.COMPRESSION_SNAPPY_VALIDATING);
        }
    }

    public static class SnappyServer
    extends BaseServerModifier {
        SnappyServer() {
            super("snappy_decoder", SnappyFrameDecoder::new, Protocol.ModifierProtocols.COMPRESSION_SNAPPY);
        }
    }

    public static class SnappyClient
    extends BaseClientModifier {
        SnappyClient() {
            super("snappy_encoder", SnappyFrameEncoder::new, Protocol.ModifierProtocols.COMPRESSION_SNAPPY, Protocol.ModifierProtocols.COMPRESSION_SNAPPY_VALIDATING);
        }
    }

    public static abstract class BaseServerModifier
    implements ModifierProtocolInstaller<ProtocolInstaller.Orientation.Server> {
        private final String pipelineDecoderName;
        private final Supplier<ByteToMessageDecoder> decoder;
        private final Collection<Protocol.ModifierProtocol> modifierProtocols;

        protected BaseServerModifier(String pipelineDecoderName, Supplier<ByteToMessageDecoder> decoder, Protocol.ModifierProtocol ... modifierProtocols) {
            this.pipelineDecoderName = pipelineDecoderName;
            this.decoder = decoder;
            this.modifierProtocols = Arrays.asList(modifierProtocols);
        }

        @Override
        public final Collection<Protocol.ModifierProtocol> protocols() {
            return this.modifierProtocols;
        }

        @Override
        public final <BUILDER extends NettyPipelineBuilder<ProtocolInstaller.Orientation.Server, BUILDER>> void apply(NettyPipelineBuilder<ProtocolInstaller.Orientation.Server, BUILDER> nettyPipelineBuilder) {
            nettyPipelineBuilder.add(this.pipelineDecoderName, (ChannelHandler)this.decoder.get());
        }
    }

    public static abstract class BaseClientModifier
    implements ModifierProtocolInstaller<ProtocolInstaller.Orientation.Client> {
        private final String pipelineEncoderName;
        private final Supplier<MessageToByteEncoder<ByteBuf>> encoder;
        private final Collection<Protocol.ModifierProtocol> modifierProtocols;

        protected BaseClientModifier(String pipelineEncoderName, Supplier<MessageToByteEncoder<ByteBuf>> encoder, Protocol.ModifierProtocol ... modifierProtocols) {
            this.pipelineEncoderName = pipelineEncoderName;
            this.encoder = encoder;
            this.modifierProtocols = Arrays.asList(modifierProtocols);
        }

        @Override
        public final Collection<Protocol.ModifierProtocol> protocols() {
            return this.modifierProtocols;
        }

        @Override
        public final <BUILDER extends NettyPipelineBuilder<ProtocolInstaller.Orientation.Client, BUILDER>> void apply(NettyPipelineBuilder<ProtocolInstaller.Orientation.Client, BUILDER> nettyPipelineBuilder) {
            nettyPipelineBuilder.add(this.pipelineEncoderName, (ChannelHandler)this.encoder.get());
        }
    }
}

