/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.encoding;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.marshalling.v2.ContentType;
import org.neo4j.causalclustering.messaging.marshalling.v2.encoding.RaftLogEntryTermEncoder;

public class RaftMessageContentSerializer
extends MessageToMessageEncoder<RaftMessages.ClusterIdAwareMessage> {
    private final CoreReplicatedContentMarshal serializer;
    private Handler replicatedContentHandler = new Handler();

    public RaftMessageContentSerializer(CoreReplicatedContentMarshal serializer) {
        this.serializer = serializer;
    }

    protected void encode(ChannelHandlerContext ctx, RaftMessages.ClusterIdAwareMessage msg, List<Object> out) throws Exception {
        out.add((Object)ContentType.Message);
        out.add(msg);
        Object[] dispatch = msg.message().dispatch(this.replicatedContentHandler);
        if (dispatch == null) {
            throw new IllegalArgumentException("Error reading raft message content");
        }
        out.addAll(Arrays.asList(dispatch));
    }

    private class Handler
    implements RaftMessages.Handler<Object[], Exception> {
        private Handler() {
        }

        @Override
        public Object[] handle(RaftMessages.Vote.Request request) throws Exception {
            return this.noContent();
        }

        @Override
        public Object[] handle(RaftMessages.Vote.Response response) throws Exception {
            return this.noContent();
        }

        @Override
        public Object[] handle(RaftMessages.PreVote.Request request) throws Exception {
            return this.noContent();
        }

        @Override
        public Object[] handle(RaftMessages.PreVote.Response response) throws Exception {
            return this.noContent();
        }

        @Override
        public Object[] handle(RaftMessages.AppendEntries.Request request) throws Exception {
            Stream<Object> terms = Stream.of(new Object[]{ContentType.RaftLogEntryTerms, RaftLogEntryTermEncoder.serializable(Arrays.stream(request.entries()).mapToLong(RaftLogEntry::term).toArray())});
            Stream contents = Arrays.stream(request.entries()).flatMap(entry -> this.serializableContents(entry.content()));
            return Stream.concat(terms, contents).toArray(Object[]::new);
        }

        @Override
        public Object[] handle(RaftMessages.AppendEntries.Response response) throws Exception {
            return this.noContent();
        }

        @Override
        public Object[] handle(RaftMessages.Heartbeat heartbeat) throws Exception {
            return this.noContent();
        }

        @Override
        public Object[] handle(RaftMessages.LogCompactionInfo logCompactionInfo) throws Exception {
            return this.noContent();
        }

        @Override
        public Object[] handle(RaftMessages.HeartbeatResponse heartbeatResponse) throws Exception {
            return this.noContent();
        }

        @Override
        public Object[] handle(RaftMessages.NewEntry.Request request) throws Exception {
            return this.serializableContents(request.content()).toArray();
        }

        @Override
        public Object[] handle(RaftMessages.Timeout.Election election) throws Exception {
            return this.illegalOutbound(election);
        }

        @Override
        public Object[] handle(RaftMessages.Timeout.Heartbeat heartbeat) throws Exception {
            return this.illegalOutbound(heartbeat);
        }

        @Override
        public Object[] handle(RaftMessages.NewEntry.BatchRequest batchRequest) throws Exception {
            return this.illegalOutbound(batchRequest);
        }

        @Override
        public Object[] handle(RaftMessages.PruneRequest pruneRequest) throws Exception {
            return this.illegalOutbound(pruneRequest);
        }

        private Object[] noContent() {
            return new Object[0];
        }

        private Object[] illegalOutbound(RaftMessages.BaseRaftMessage raftMessage) {
            throw new IllegalStateException("Illegal outbound call: " + raftMessage.getClass());
        }

        private Stream<Object> serializableContents(ReplicatedContent content) {
            return Stream.concat(Stream.of(ContentType.ReplicatedContent), RaftMessageContentSerializer.this.serializer.toSerializable(content).stream());
        }
    }
}

