/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.decoding;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;
import org.neo4j.storageengine.api.ReadableChannel;

public class ReplicatedContentChunkDecoder
extends ByteToMessageDecoder
implements AutoCloseable {
    private final CoreReplicatedContentMarshal contentMarshal = new CoreReplicatedContentMarshal();
    private UnfinishedChunk unfinishedChunk;

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            boolean isLast = in.readBoolean();
            if (this.unfinishedChunk == null) {
                byte contentType = in.readByte();
                int allocationSize = in.readInt();
                if (isLast) {
                    out.add(this.contentMarshal.read(contentType, (ReadableChannel)new NetworkReadableClosableChannelNetty4(in.readSlice(in.readableBytes()))));
                } else {
                    ByteBuf replicatedContentBuffer = allocationSize == -1 ? in.copy() : ctx.alloc().buffer(allocationSize, allocationSize);
                    this.unfinishedChunk = new UnfinishedChunk(contentType, replicatedContentBuffer);
                    this.unfinishedChunk.consume(in);
                }
            } else {
                this.unfinishedChunk.consume(in);
                if (isLast) {
                    out.add(this.contentMarshal.read(this.unfinishedChunk.contentType, (ReadableChannel)new NetworkReadableClosableChannelNetty4(this.unfinishedChunk.content())));
                    this.unfinishedChunk.release();
                    this.unfinishedChunk = null;
                }
            }
        }
        catch (Throwable e) {
            this.release();
            throw e;
        }
    }

    private void release() {
        if (this.unfinishedChunk != null) {
            this.unfinishedChunk.release();
            this.unfinishedChunk = null;
        }
    }

    @Override
    public void close() {
        this.release();
    }

    private static class UnfinishedChunk
    extends DefaultByteBufHolder {
        private final byte contentType;

        UnfinishedChunk(byte contentType, ByteBuf byteBuf) {
            super(byteBuf);
            this.contentType = contentType;
        }

        void consume(ByteBuf replicatedContentChunk) {
            this.content().writeBytes(replicatedContentChunk);
        }
    }
}

