/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.decoding;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.neo4j.causalclustering.catchup.Protocol;
import org.neo4j.causalclustering.catchup.RequestDecoderDispatcher;
import org.neo4j.causalclustering.messaging.marshalling.v2.ContentType;
import org.neo4j.causalclustering.messaging.marshalling.v2.decoding.RaftLogEntryTermsDecoder;
import org.neo4j.causalclustering.messaging.marshalling.v2.decoding.RaftMessageDecoder;
import org.neo4j.causalclustering.messaging.marshalling.v2.decoding.ReplicatedContentChunkDecoder;
import org.neo4j.logging.LogProvider;

public class DecodingDispatcher
extends RequestDecoderDispatcher<ContentType> {
    private final ReplicatedContentChunkDecoder decoder = new ReplicatedContentChunkDecoder();

    public DecodingDispatcher(Protocol<ContentType> protocol, LogProvider logProvider) {
        super(protocol, logProvider);
        this.register(ContentType.ContentType, (ChannelInboundHandler)new ByteToMessageDecoder(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
                if (in.readableBytes() > 0) {
                    throw new IllegalStateException("Not expecting any data here");
                }
            }
        });
        this.register(ContentType.RaftLogEntryTerms, (ChannelInboundHandler)new RaftLogEntryTermsDecoder(protocol));
        this.register(ContentType.ReplicatedContent, (ChannelInboundHandler)this.decoder);
        this.register(ContentType.Message, (ChannelInboundHandler)new RaftMessageDecoder(protocol));
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.decoder.close();
        ctx.fireChannelInactive();
    }
}

