/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.decoding;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.neo4j.causalclustering.catchup.Protocol;
import org.neo4j.causalclustering.messaging.marshalling.v2.ContentType;

public class ContentTypeDispatcher
extends ByteToMessageDecoder {
    private final Protocol<ContentType> contentTypeProtocol;

    public ContentTypeDispatcher(Protocol<ContentType> contentTypeProtocol) {
        this.contentTypeProtocol = contentTypeProtocol;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.contentTypeProtocol.isExpecting(ContentType.ContentType)) {
            byte messageCode = in.readByte();
            ContentType contentType = this.getContentType(messageCode);
            this.contentTypeProtocol.expect(contentType);
        } else {
            ctx.fireChannelRead((Object)in.retain());
        }
    }

    private ContentType getContentType(byte messageCode) {
        for (ContentType contentType : ContentType.values()) {
            if (contentType.get() != messageCode) continue;
            return contentType;
        }
        throw new IllegalArgumentException("Illegal inbound. Could not find a ContentType with value " + messageCode);
    }
}

