/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSetSerializer;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenSerializer;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionSerializer;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ByteBufAwareMarshal;
import org.neo4j.causalclustering.messaging.marshalling.ChunkedReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ContentBuilder;
import org.neo4j.causalclustering.messaging.marshalling.Marshal;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class CoreReplicatedContentMarshal
extends SafeChannelMarshal<ReplicatedContent> {
    private static final byte TX_CONTENT_TYPE = 0;
    private static final byte RAFT_MEMBER_SET_TYPE = 1;
    private static final byte ID_RANGE_REQUEST_TYPE = 2;
    private static final byte TOKEN_REQUEST_TYPE = 4;
    private static final byte NEW_LEADER_BARRIER_TYPE = 5;
    private static final byte LOCK_TOKEN_REQUEST = 6;
    private static final byte DISTRIBUTED_OPERATION = 7;
    private static final byte DUMMY_REQUEST = 8;

    public Collection<Marshal> toSerializable(ReplicatedContent content) {
        if (content instanceof ReplicatedTransaction) {
            return Collections.singleton(new ChunkedReplicatedContent(0, ReplicatedTransactionSerializer.serializer((ReplicatedTransaction)content)));
        }
        if (content instanceof MemberIdSet) {
            return Collections.singleton(new ChunkedReplicatedContent(1, ByteBufAwareMarshal.simple((ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> MemberIdSetSerializer.marshal((MemberIdSet)content, channel)))));
        }
        if (content instanceof ReplicatedIdAllocationRequest) {
            return Collections.singleton(new ChunkedReplicatedContent(2, ByteBufAwareMarshal.simple((ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> ReplicatedIdAllocationRequestSerializer.marshal((ReplicatedIdAllocationRequest)content, channel)))));
        }
        if (content instanceof ReplicatedTokenRequest) {
            return Collections.singleton(new ChunkedReplicatedContent(4, ByteBufAwareMarshal.simple((ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> ReplicatedTokenRequestSerializer.marshal((ReplicatedTokenRequest)content, channel)))));
        }
        if (content instanceof NewLeaderBarrier) {
            return Collections.singleton(new ChunkedReplicatedContent(5, ByteBufAwareMarshal.simple((ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> {}))));
        }
        if (content instanceof ReplicatedLockTokenRequest) {
            return Collections.singleton(new ChunkedReplicatedContent(6, ByteBufAwareMarshal.simple((ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> ReplicatedLockTokenSerializer.marshal((ReplicatedLockTokenRequest)content, channel)))));
        }
        if (content instanceof DistributedOperation) {
            LinkedList<Marshal> list = new LinkedList<Marshal>(this.toSerializable(((DistributedOperation)content).content()));
            list.add(0, new ChunkedReplicatedContent(7, ((DistributedOperation)content).serialize()));
            return list;
        }
        if (content instanceof DummyRequest) {
            return Collections.singleton(new ChunkedReplicatedContent(8, ((DummyRequest)content).serializer()));
        }
        throw new IllegalArgumentException("Unknown content type " + content.getClass());
    }

    public ContentBuilder<ReplicatedContent> read(byte contentType, ReadableChannel channel) throws IOException, EndOfStreamException {
        switch (contentType) {
            case 0: {
                return ContentBuilder.finished(ReplicatedTransactionSerializer.unmarshal(channel));
            }
            case 1: {
                return ContentBuilder.finished(MemberIdSetSerializer.unmarshal(channel));
            }
            case 2: {
                return ContentBuilder.finished(ReplicatedIdAllocationRequestSerializer.unmarshal(channel));
            }
            case 4: {
                return ContentBuilder.finished(ReplicatedTokenRequestSerializer.unmarshal(channel));
            }
            case 5: {
                return ContentBuilder.finished(new NewLeaderBarrier());
            }
            case 6: {
                return ContentBuilder.finished(ReplicatedLockTokenSerializer.unmarshal(channel));
            }
            case 7: {
                return DistributedOperation.deserialize(channel);
            }
            case 8: {
                return ContentBuilder.finished(DummyRequest.Marshal.INSTANCE.unmarshal(channel));
            }
        }
        throw new IllegalStateException("Not a recognized content type: " + contentType);
    }

    @Override
    public void marshal(ReplicatedContent coreReplicatedContent, WritableChannel channel) throws IOException {
        for (Marshal marshal : this.toSerializable(coreReplicatedContent)) {
            marshal.marshal(channel);
        }
    }

    @Override
    protected ReplicatedContent unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
        byte type = channel.get();
        ContentBuilder<ReplicatedContent> contentBuilder = this.read(type, channel);
        while (!contentBuilder.isComplete()) {
            type = channel.get();
            contentBuilder = contentBuilder.combine(this.read(type, channel));
        }
        return contentBuilder.build();
    }
}

