/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.io.IOException;
import org.neo4j.causalclustering.messaging.marshalling.ByteBufAwareMarshal;
import org.neo4j.causalclustering.messaging.marshalling.Marshal;
import org.neo4j.storageengine.api.WritableChannel;

public class ChunkedReplicatedContent
implements Marshal,
ChunkedInput<ByteBuf> {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private static final int MINIMUM_CHUNK_SIZE = 8;
    private final byte contentType;
    private final ByteBufAwareMarshal byteBufAwareMarshal;
    private final int chunkSize;
    private boolean endOfInput;
    private int progress;

    private ChunkedReplicatedContent(byte contentType, ByteBufAwareMarshal byteBufAwareMarshal, int chunkSize) {
        if (chunkSize < 8) {
            throw new IllegalArgumentException("Chunk size must be at least 8 bytes");
        }
        this.byteBufAwareMarshal = byteBufAwareMarshal;
        this.chunkSize = chunkSize;
        this.contentType = contentType;
    }

    ChunkedReplicatedContent(byte contentType, ByteBufAwareMarshal byteBufAwareMarshal) {
        this(contentType, byteBufAwareMarshal, 8192);
    }

    @Override
    public void marshal(WritableChannel channel) throws IOException {
        channel.put(this.contentType);
        this.byteBufAwareMarshal.marshal(channel);
    }

    public boolean isEndOfInput() {
        return this.endOfInput;
    }

    public void close() {
    }

    public ByteBuf readChunk(ChannelHandlerContext ctx) throws IOException {
        return this.readChunk(ctx.alloc());
    }

    public ByteBuf readChunk(ByteBufAllocator allocator) throws IOException {
        if (this.endOfInput) {
            return null;
        }
        ByteBuf buffer = allocator.buffer(this.chunkSize);
        try {
            buffer.writerIndex(1);
            if (this.progress() == 0L) {
                buffer.writeByte((int)this.contentType);
                buffer.writeInt(this.byteBufAwareMarshal.length());
            }
            if (!this.byteBufAwareMarshal.encode(buffer)) {
                this.endOfInput = true;
            }
            this.progress += buffer.readableBytes();
            assert (this.progress > 0);
            buffer.setBoolean(0, this.endOfInput);
            return buffer;
        }
        catch (Throwable e) {
            buffer.release();
            throw e;
        }
    }

    public long length() {
        return -1L;
    }

    public long progress() {
        return this.progress;
    }
}

