/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.neo4j.causalclustering.messaging.NetworkFlushableChannelNetty4;
import org.neo4j.causalclustering.messaging.marshalling.Marshal;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.storageengine.api.WritableChannel;

public interface ByteBufAwareMarshal
extends Marshal {
    public static ByteBufAwareMarshal simple(final ThrowingConsumer<WritableChannel, IOException> channelConsumer) {
        return new ByteBufAwareMarshal(){
            private boolean consumed;

            @Override
            public boolean encode(ByteBuf byteBuf) throws IOException {
                if (this.consumed) {
                    return false;
                }
                this.marshal((WritableChannel)new NetworkFlushableChannelNetty4(byteBuf));
                this.consumed = true;
                return false;
            }

            @Override
            public int length() {
                return -1;
            }

            @Override
            public void marshal(WritableChannel channel) throws IOException {
                channelConsumer.accept((Object)channel);
            }
        };
    }

    public boolean encode(ByteBuf var1) throws IOException;

    default public int length() {
        return -1;
    }
}

