/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.neo4j.causalclustering.messaging.marshalling.ByteBufAwareMarshal;
import org.neo4j.storageengine.api.WritableChannel;

public class ByteArrayByteBufAwareMarshal
implements ByteBufAwareMarshal {
    private final byte[] content;
    private final ByteArrayInputStream inputStream;

    public ByteArrayByteBufAwareMarshal(byte[] content) {
        this.inputStream = new ByteArrayInputStream(content);
        this.content = content;
    }

    @Override
    public boolean encode(ByteBuf byteBuf) throws IOException {
        if (this.inputStream.available() == this.content.length) {
            if (!byteBuf.isWritable(5)) {
                return true;
            }
            byteBuf.writeInt(this.content.length);
        }
        if (!this.hasBytes()) {
            return false;
        }
        int toWrite = Math.min(this.inputStream.available(), byteBuf.writableBytes());
        byteBuf.writeBytes((InputStream)this.inputStream, toWrite);
        return this.hasBytes();
    }

    @Override
    public int length() {
        return this.content.length + 4;
    }

    private boolean hasBytes() {
        return this.inputStream.available() > 0;
    }

    @Override
    public void marshal(WritableChannel channel) throws IOException {
        int length = this.content.length;
        channel.putInt(length);
        channel.put(this.content, length);
    }
}

