/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.causalclustering.messaging.address.UnknownAddressMonitor;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;

public class RaftOutbound
implements Outbound<MemberId, RaftMessages.RaftMessage> {
    private final CoreTopologyService coreTopologyService;
    private final Outbound<AdvertisedSocketAddress, Message> outbound;
    private final Supplier<Optional<ClusterId>> clusterIdentity;
    private final UnknownAddressMonitor unknownAddressMonitor;
    private final Log log;

    public RaftOutbound(CoreTopologyService coreTopologyService, Outbound<AdvertisedSocketAddress, Message> outbound, Supplier<Optional<ClusterId>> clusterIdentity, LogProvider logProvider, long logThresholdMillis) {
        this.coreTopologyService = coreTopologyService;
        this.outbound = outbound;
        this.clusterIdentity = clusterIdentity;
        this.log = logProvider.getLog(this.getClass());
        this.unknownAddressMonitor = new UnknownAddressMonitor(this.log, Clocks.systemClock(), logThresholdMillis);
    }

    @Override
    public void send(MemberId to, RaftMessages.RaftMessage message, boolean block) {
        Optional<ClusterId> clusterId = this.clusterIdentity.get();
        if (!clusterId.isPresent()) {
            this.log.warn("Attempting to send a message before bound to a cluster");
            return;
        }
        Optional coreServerInfo = this.coreTopologyService.localCoreServers().find(to);
        if (coreServerInfo.isPresent()) {
            this.outbound.send(((CoreServerInfo)coreServerInfo.get()).getRaftServer(), RaftMessages.ClusterIdAwareMessage.of(clusterId.get(), message), block);
        } else {
            this.unknownAddressMonitor.logAttemptToSendToMemberWithNoKnownAddress(to);
        }
    }
}

