/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.helper.TimeoutStrategy;

public class ExponentialBackoffStrategy
implements TimeoutStrategy {
    private final long initialBackoffTimeMillis;
    private final long upperBoundBackoffTimeMillis;

    public ExponentialBackoffStrategy(long initialBackoffTime, long upperBoundBackoffTime, TimeUnit timeUnit) {
        assert (initialBackoffTime <= upperBoundBackoffTime);
        this.initialBackoffTimeMillis = timeUnit.toMillis(initialBackoffTime);
        this.upperBoundBackoffTimeMillis = timeUnit.toMillis(upperBoundBackoffTime);
    }

    public ExponentialBackoffStrategy(Duration initialBackoffTime, Duration upperBoundBackoffTime) {
        this(initialBackoffTime.toMillis(), upperBoundBackoffTime.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public TimeoutStrategy.Timeout newTimeout() {
        return new TimeoutStrategy.Timeout(){
            private long backoffTimeMillis;
            {
                this.backoffTimeMillis = ExponentialBackoffStrategy.this.initialBackoffTimeMillis;
            }

            @Override
            public long getMillis() {
                return this.backoffTimeMillis;
            }

            @Override
            public void increment() {
                this.backoffTimeMillis = Math.min(this.backoffTimeMillis * 2L, ExponentialBackoffStrategy.this.upperBoundBackoffTimeMillis);
            }
        };
    }
}

