/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.util.ArrayList;
import java.util.List;

public class ErrorHandler
implements AutoCloseable {
    private final List<Throwable> throwables = new ArrayList<Throwable>();
    private final String message;

    public static void runAll(String description, ThrowingRunnable ... actions) throws RuntimeException {
        try (ErrorHandler errorHandler = new ErrorHandler(description);){
            for (ThrowingRunnable action : actions) {
                try {
                    action.run();
                }
                catch (Throwable e) {
                    errorHandler.add(e);
                }
            }
        }
    }

    public ErrorHandler(String message) {
        this.message = message;
    }

    public void add(Throwable throwable) {
        this.throwables.add(throwable);
    }

    @Override
    public void close() throws RuntimeException {
        this.throwIfException();
    }

    private void throwIfException() {
        if (!this.throwables.isEmpty()) {
            Throwable runtimeException = null;
            for (Throwable throwable : this.throwables) {
                if (runtimeException == null) {
                    runtimeException = new RuntimeException(this.message, throwable);
                    continue;
                }
                runtimeException.addSuppressed(throwable);
            }
            throw runtimeException;
        }
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

