/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.discovery.Difference;
import org.neo4j.causalclustering.discovery.DiscoveryServerInfo;
import org.neo4j.causalclustering.discovery.TopologyDifference;
import org.neo4j.causalclustering.identity.MemberId;

public interface Topology<T extends DiscoveryServerInfo> {
    public Map<MemberId, T> members();

    default public TopologyDifference difference(Topology<T> other) {
        Set<MemberId> members = this.members().keySet();
        Set<MemberId> otherMembers = other.members().keySet();
        Set<Difference> added = otherMembers.stream().filter(m -> !members.contains(m)).map(memberId -> Difference.asDifference(other, memberId)).collect(Collectors.toSet());
        Set<Difference> removed = members.stream().filter(m -> !otherMembers.contains(m)).map(memberId -> Difference.asDifference(this, memberId)).collect(Collectors.toSet());
        return new TopologyDifference(added, removed);
    }

    default public Optional<T> find(MemberId memberId) {
        return Optional.ofNullable(this.members().get(memberId));
    }

    default public Map<MemberId, T> filterHostsByDb(Map<MemberId, T> s, String dbName) {
        return s.entrySet().stream().filter(e -> ((DiscoveryServerInfo)e.getValue()).getDatabaseName().equals(dbName)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Topology<T> filterTopologyByDb(String var1);
}

