/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Set;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.core.consensus.LeaderListener;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class RaftCoreTopologyConnector
extends LifecycleAdapter
implements CoreTopologyService.Listener,
LeaderListener {
    private final CoreTopologyService coreTopologyService;
    private final RaftMachine raftMachine;
    private final String dbName;

    public RaftCoreTopologyConnector(CoreTopologyService coreTopologyService, RaftMachine raftMachine, String dbName) {
        this.coreTopologyService = coreTopologyService;
        this.raftMachine = raftMachine;
        this.dbName = dbName;
    }

    public void start() {
        this.coreTopologyService.addLocalCoreTopologyListener(this);
        this.raftMachine.registerListener(this);
    }

    @Override
    public synchronized void onCoreTopologyChange(CoreTopology coreTopology) {
        Set<MemberId> targetMembers = coreTopology.members().keySet();
        this.raftMachine.setTargetMembershipSet(targetMembers);
    }

    @Override
    public void onLeaderSwitch(LeaderInfo leaderInfo) {
        this.coreTopologyService.setLeader(leaderInfo, this.dbName);
    }

    @Override
    public void onLeaderStepDown(long stepDownTerm) {
        this.coreTopologyService.handleStepDown(stepDownTerm, this.dbName);
    }

    @Override
    public String dbName() {
        return this.dbName;
    }
}

