/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.config.Config;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.properties.GroupProperty;
import java.time.Duration;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyListenerService;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.TopologyDifference;
import org.neo4j.causalclustering.discovery.TopologyServiceRetryStrategy;
import org.neo4j.causalclustering.helper.RobustJobSchedulerWrapper;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.function.ThrowingAction;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class HazelcastCoreTopologyService
implements CoreTopologyService,
Lifecycle {
    private static final long HAZELCAST_IS_HEALTHY_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(10L);
    private static final int HAZELCAST_MIN_CLUSTER = 2;
    private final org.neo4j.kernel.configuration.Config config;
    private final MemberId myself;
    private final Log log;
    private final Log userLog;
    private final CoreTopologyListenerService listenerService;
    private final RobustJobSchedulerWrapper scheduler;
    private final long refreshPeriod;
    private final HostnameResolver hostnameResolver;
    private final TopologyServiceRetryStrategy topologyServiceRetryStrategy;
    private final Monitor monitor;
    private final String localDBName;
    private JobScheduler.JobHandle refreshJob;
    private final AtomicReference<LeaderInfo> leaderInfo = new AtomicReference<LeaderInfo>(LeaderInfo.INITIAL);
    private final AtomicReference<Optional<LeaderInfo>> stepDownInfo = new AtomicReference(Optional.empty());
    private volatile HazelcastInstance hazelcastInstance;
    private volatile CoreTopology coreTopology = CoreTopology.EMPTY;
    private volatile CoreTopology localCoreTopology = CoreTopology.EMPTY;
    private volatile ReadReplicaTopology readReplicaTopology = ReadReplicaTopology.EMPTY;
    private volatile ReadReplicaTopology localReadReplicaTopology = ReadReplicaTopology.EMPTY;
    private volatile Map<MemberId, AdvertisedSocketAddress> catchupAddressMap = new HashMap<MemberId, AdvertisedSocketAddress>();
    private volatile Map<MemberId, RoleInfo> coreRoles = Collections.emptyMap();
    private Thread startingThread;
    private volatile boolean stopped;

    public HazelcastCoreTopologyService(org.neo4j.kernel.configuration.Config config, MemberId myself, JobScheduler jobScheduler, LogProvider logProvider, LogProvider userLogProvider, HostnameResolver hostnameResolver, TopologyServiceRetryStrategy topologyServiceRetryStrategy, Monitors monitors) {
        this.config = config;
        this.myself = myself;
        this.listenerService = new CoreTopologyListenerService();
        this.log = logProvider.getLog(this.getClass());
        this.scheduler = new RobustJobSchedulerWrapper(jobScheduler, this.log);
        this.userLog = userLogProvider.getLog(this.getClass());
        this.refreshPeriod = ((Duration)config.get(CausalClusteringSettings.cluster_topology_refresh)).toMillis();
        this.hostnameResolver = hostnameResolver;
        this.topologyServiceRetryStrategy = topologyServiceRetryStrategy;
        this.monitor = (Monitor)monitors.newMonitor(Monitor.class, new String[0]);
        this.localDBName = (String)config.get(CausalClusteringSettings.database);
    }

    @Override
    public void addLocalCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listenerService.addCoreTopologyListener(listener);
        listener.onCoreTopologyChange(this.localCoreServers());
    }

    @Override
    public void removeLocalCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listenerService.removeCoreTopologyListener(listener);
    }

    @Override
    public boolean setClusterId(ClusterId clusterId, String dbName) throws InterruptedException {
        this.waitOnHazelcastInstanceCreation();
        return HazelcastClusterTopology.casClusterId(this.hazelcastInstance, clusterId, dbName);
    }

    @Override
    public void setLeader(LeaderInfo newLeaderInfo, String dbName) {
        this.leaderInfo.updateAndGet(currentLeaderInfo -> {
            if (currentLeaderInfo.term() < newLeaderInfo.term() && this.localDBName.equals(dbName)) {
                this.log.info("Leader %s updating leader info for database %s and term %s", new Object[]{this.myself, this.localDBName, newLeaderInfo.term()});
                return newLeaderInfo;
            }
            return currentLeaderInfo;
        });
    }

    @Override
    public void handleStepDown(long term, String dbName) {
        boolean wasLeaderForDbAndTerm;
        LeaderInfo localLeaderInfo = this.leaderInfo.get();
        boolean bl = wasLeaderForDbAndTerm = Objects.equals(this.myself, localLeaderInfo.memberId()) && this.localDBName.equals(dbName) && term == localLeaderInfo.term();
        if (wasLeaderForDbAndTerm) {
            this.log.info("Step down event detected. This topology member, with MemberId %s, was leader in term %s, now moving to follower.", new Object[]{this.myself, localLeaderInfo.term()});
            this.stepDownInfo.set(Optional.of(localLeaderInfo.stepDown()));
        }
    }

    @Override
    public Map<MemberId, RoleInfo> allCoreRoles() {
        return this.coreRoles;
    }

    @Override
    public String localDBName() {
        return this.localDBName;
    }

    public void init() {
    }

    public void start() {
        this.startingThread = new Thread(() -> {
            this.log.info("Cluster discovery service starting");
            this.hazelcastInstance = this.createHazelcastInstance();
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.refreshJob = this.scheduler.scheduleRecurring("TopologyRefresh", this.refreshPeriod, (ThrowingAction<Exception>)((ThrowingAction)this::refreshTopology));
            this.log.info("Cluster discovery service started");
        });
        this.startingThread.setDaemon(true);
        this.startingThread.setName("HZ Starting Thread");
        this.startingThread.start();
    }

    public void stop() {
        this.log.info(String.format("HazelcastCoreTopologyService stopping and unbinding from %s", this.config.get(CausalClusteringSettings.discovery_listen_address)));
        this.startingThread.interrupt();
        this.stopped = true;
        if (this.refreshJob != null) {
            this.refreshJob.cancel(true);
        }
        if (this.hazelcastInstance != null) {
            try {
                this.hazelcastInstance.getLifecycleService().shutdown();
            }
            catch (Throwable e) {
                this.log.warn("Failed to stop Hazelcast", e);
            }
        }
    }

    public void shutdown() {
    }

    private HazelcastInstance createHazelcastInstance() {
        JoinConfig joinConfig = new JoinConfig();
        joinConfig.getMulticastConfig().setEnabled(false);
        TcpIpConfig tcpIpConfig = joinConfig.getTcpIpConfig();
        tcpIpConfig.setEnabled(true);
        List initialMembers = (List)this.config.get(CausalClusteringSettings.initial_discovery_members);
        for (AdvertisedSocketAddress address : initialMembers) {
            for (AdvertisedSocketAddress advertisedSocketAddress : this.hostnameResolver.resolve(address)) {
                tcpIpConfig.addMember(advertisedSocketAddress.toString());
            }
        }
        ListenSocketAddress hazelcastAddress = (ListenSocketAddress)this.config.get(CausalClusteringSettings.discovery_listen_address);
        NetworkConfig networkConfig = new NetworkConfig();
        if (!hazelcastAddress.isWildcard()) {
            InterfacesConfig interfaces = new InterfacesConfig();
            interfaces.addInterface(hazelcastAddress.getHostname());
            interfaces.setEnabled(true);
            networkConfig.setInterfaces(interfaces);
        }
        networkConfig.setPort(hazelcastAddress.getPort());
        networkConfig.setJoin(joinConfig);
        networkConfig.setPortAutoIncrement(false);
        Long electionTimeoutMillis = ((Duration)this.config.get(CausalClusteringSettings.leader_election_timeout)).toMillis();
        Long baseHazelcastTimeoutMillis = 3L * electionTimeoutMillis / 2L;
        long baseHazelcastTimeoutSeconds = (baseHazelcastTimeoutMillis + 1000L - 1L) / 1000L;
        Config c = new Config();
        c.setProperty(GroupProperty.OPERATION_CALL_TIMEOUT_MILLIS.getName(), String.valueOf(baseHazelcastTimeoutMillis));
        c.setProperty(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS.getName(), String.valueOf(baseHazelcastTimeoutSeconds));
        c.setProperty(GroupProperty.MERGE_FIRST_RUN_DELAY_SECONDS.getName(), String.valueOf(baseHazelcastTimeoutSeconds));
        c.setProperty(GroupProperty.INITIAL_MIN_CLUSTER_SIZE.getName(), String.valueOf(2));
        if (((Boolean)this.config.get(CausalClusteringSettings.disable_middleware_logging)).booleanValue()) {
            c.setProperty(GroupProperty.LOGGING_TYPE.getName(), "none");
        }
        if (hazelcastAddress.isIPv6()) {
            c.setProperty(GroupProperty.PREFER_IPv4_STACK.getName(), "false");
        }
        c.setNetworkConfig(networkConfig);
        MemberAttributeConfig memberAttributeConfig = HazelcastClusterTopology.buildMemberAttributesForCore(this.myself, this.config);
        c.setMemberAttributeConfig(memberAttributeConfig);
        this.logConnectionInfo(initialMembers);
        c.addListenerConfig(new ListenerConfig((EventListener)((Object)new OurMembershipListener())));
        JobScheduler.JobHandle logJob = this.scheduler.schedule("HazelcastHealth", HAZELCAST_IS_HEALTHY_TIMEOUT_MS, (ThrowingAction<Exception>)((ThrowingAction)() -> this.log.warn("The server has not been able to connect in a timely fashion to the cluster. Please consult the logs for more details. Rebooting the server may solve the problem.")));
        try {
            this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)c);
            logJob.cancel(true);
        }
        catch (HazelcastException e) {
            String errorMessage = String.format("Hazelcast was unable to start with setting: %s = %s", CausalClusteringSettings.discovery_listen_address.name(), this.config.get(CausalClusteringSettings.discovery_listen_address));
            this.userLog.error(errorMessage);
            this.log.error(errorMessage, (Throwable)e);
            throw new RuntimeException(e);
        }
        List groups = (List)this.config.get(CausalClusteringSettings.server_groups);
        HazelcastClusterTopology.refreshGroups(this.hazelcastInstance, this.myself.getUuid().toString(), groups);
        return this.hazelcastInstance;
    }

    private void logConnectionInfo(List<AdvertisedSocketAddress> initialMembers) {
        this.userLog.info("My connection info: [\n\tDiscovery:   listen=%s, advertised=%s,\n\tTransaction: listen=%s, advertised=%s, \n\tRaft:        listen=%s, advertised=%s, \n\tClient Connector Addresses: %s\n]", new Object[]{this.config.get(CausalClusteringSettings.discovery_listen_address), this.config.get(CausalClusteringSettings.discovery_advertised_address), this.config.get(CausalClusteringSettings.transaction_listen_address), this.config.get(CausalClusteringSettings.transaction_advertised_address), this.config.get(CausalClusteringSettings.raft_listen_address), this.config.get(CausalClusteringSettings.raft_advertised_address), ClientConnectorAddresses.extractFromConfig(this.config)});
        this.userLog.info("Discovering other core members in initial members set: " + initialMembers);
    }

    @Override
    public CoreTopology allCoreServers() {
        return this.coreTopology;
    }

    @Override
    public CoreTopology localCoreServers() {
        return this.localCoreTopology;
    }

    @Override
    public ReadReplicaTopology allReadReplicas() {
        return this.readReplicaTopology;
    }

    @Override
    public ReadReplicaTopology localReadReplicas() {
        return this.localReadReplicaTopology;
    }

    @Override
    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId memberId) {
        return this.topologyServiceRetryStrategy.apply(memberId, this::retrieveSocketAddress, Optional::isPresent);
    }

    private Optional<AdvertisedSocketAddress> retrieveSocketAddress(MemberId memberId) {
        return Optional.ofNullable(this.catchupAddressMap.get(memberId));
    }

    private void refreshRoles() throws InterruptedException {
        this.waitOnHazelcastInstanceCreation();
        LeaderInfo localLeaderInfo = this.leaderInfo.get();
        Optional<LeaderInfo> localStepDownInfo = this.stepDownInfo.get();
        if (localStepDownInfo.isPresent()) {
            HazelcastClusterTopology.casLeaders(this.hazelcastInstance, localStepDownInfo.get(), this.localDBName);
            this.stepDownInfo.compareAndSet(localStepDownInfo, Optional.empty());
        } else if (localLeaderInfo.memberId() != null && localLeaderInfo.memberId().equals(this.myself)) {
            HazelcastClusterTopology.casLeaders(this.hazelcastInstance, localLeaderInfo, this.localDBName);
        }
        this.coreRoles = HazelcastClusterTopology.getCoreRoles(this.hazelcastInstance, this.allCoreServers().members().keySet());
    }

    private synchronized void refreshTopology() throws InterruptedException {
        this.refreshCoreTopology();
        this.refreshReadReplicaTopology();
        this.refreshRoles();
        this.catchupAddressMap = HazelcastClusterTopology.extractCatchupAddressesMap(this.localCoreServers(), this.localReadReplicas());
    }

    private void refreshCoreTopology() throws InterruptedException {
        this.waitOnHazelcastInstanceCreation();
        CoreTopology newCoreTopology = HazelcastClusterTopology.getCoreTopology(this.hazelcastInstance, this.config, this.log);
        TopologyDifference difference = this.coreTopology.difference(newCoreTopology);
        this.coreTopology = newCoreTopology;
        this.localCoreTopology = newCoreTopology.filterTopologyByDb(this.localDBName);
        if (difference.hasChanges()) {
            this.log.info("Core topology changed %s", new Object[]{difference});
            this.listenerService.notifyListeners(this.coreTopology);
        }
    }

    private void refreshReadReplicaTopology() throws InterruptedException {
        this.waitOnHazelcastInstanceCreation();
        ReadReplicaTopology newReadReplicaTopology = HazelcastClusterTopology.getReadReplicaTopology(this.hazelcastInstance, this.log);
        TopologyDifference difference = this.readReplicaTopology.difference(newReadReplicaTopology);
        this.readReplicaTopology = newReadReplicaTopology;
        this.localReadReplicaTopology = newReadReplicaTopology.filterTopologyByDb(this.localDBName);
        if (difference.hasChanges()) {
            this.log.info("Read replica topology changed %s", new Object[]{difference});
        }
    }

    private void waitOnHazelcastInstanceCreation() throws InterruptedException {
        while (this.hazelcastInstance == null && !this.stopped) {
            Thread.sleep(200L);
        }
    }

    private class OurMembershipListener
    implements MembershipListener {
        private OurMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            if (!membershipEvent.getMember().localMember()) {
                Address address = membershipEvent.getMember().getAddress();
                HazelcastCoreTopologyService.this.monitor.discoveredMember(new SocketAddress(address.getHost(), address.getPort()));
            }
            try {
                HazelcastCoreTopologyService.this.refreshTopology();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            if (!membershipEvent.getMember().localMember()) {
                Address address = membershipEvent.getMember().getAddress();
                HazelcastCoreTopologyService.this.monitor.lostMember(new SocketAddress(address.getHost(), address.getPort()));
            }
            try {
                HazelcastCoreTopologyService.this.refreshTopology();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            HazelcastCoreTopologyService.this.log.info("Core member attribute changed %s", new Object[]{memberAttributeEvent});
        }
    }

    public static interface Monitor {
        public void discoveredMember(SocketAddress var1);

        public void lostMember(SocketAddress var1);
    }
}

