/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.diagnostics;

import java.time.Duration;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.consensus.membership.MembershipWaiter;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.PersistentSnapshotDownloader;
import org.neo4j.causalclustering.discovery.HazelcastCoreTopologyService;
import org.neo4j.causalclustering.helper.Limiters;
import org.neo4j.causalclustering.identity.ClusterBinder;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CoreMonitor
implements ClusterBinder.Monitor,
HazelcastCoreTopologyService.Monitor,
PersistentSnapshotDownloader.Monitor,
MembershipWaiter.Monitor {
    private final Log debug;
    private final Log user;
    private final Log dual;
    private final Consumer<Runnable> binderLimit = Limiters.rateLimiter(Duration.ofSeconds(10L));
    private final Consumer<Runnable> waiterLimit = Limiters.rateLimiter(Duration.ofSeconds(10L));

    public static void register(LogProvider debugLogProvider, LogProvider userLogProvider, Monitors monitors) {
        new CoreMonitor(debugLogProvider, userLogProvider, monitors);
    }

    private CoreMonitor(LogProvider debugLogProvider, LogProvider userLogProvider, Monitors monitors) {
        this.debug = debugLogProvider.getLog(this.getClass());
        this.user = userLogProvider.getLog(this.getClass());
        this.dual = new DuplicatingLog(new Log[]{this.user, this.debug});
        monitors.addMonitorListener((Object)this, new String[0]);
    }

    @Override
    public void waitingForCoreMembers(int minimumCount) {
        this.binderLimit.accept(() -> {
            String message = "Waiting for a total of %d core members...";
            this.dual.info(String.format(message, minimumCount));
        });
    }

    @Override
    public void waitingForBootstrap() {
        this.binderLimit.accept(() -> this.dual.info("Waiting for bootstrap by other instance..."));
    }

    @Override
    public void bootstrapped(CoreSnapshot snapshot, ClusterId clusterId) {
        this.user.info("This instance bootstrapped the cluster.");
        this.debug.info(String.format("Bootstrapped with snapshot: %s and clusterId: %s", snapshot, clusterId));
    }

    @Override
    public void boundToCluster(ClusterId clusterId) {
        this.dual.info("Bound to cluster with id " + clusterId.uuid());
    }

    @Override
    public void discoveredMember(SocketAddress socketAddress) {
        this.dual.info("Discovered core member at " + socketAddress);
    }

    @Override
    public void lostMember(SocketAddress socketAddress) {
        this.dual.warn("Lost core member at " + socketAddress);
    }

    @Override
    public void startedDownloadingSnapshot() {
        this.dual.info("Started downloading snapshot...");
    }

    @Override
    public void downloadSnapshotComplete() {
        this.dual.info("Download of snapshot complete.");
    }

    @Override
    public void waitingToHearFromLeader() {
        this.waiterLimit.accept(() -> this.dual.info("Waiting to hear from leader..."));
    }

    @Override
    public void waitingToCatchupWithLeader(long localCommitIndex, long leaderCommitIndex) {
        this.waiterLimit.accept(() -> {
            long gap = leaderCommitIndex - localCommitIndex;
            this.dual.info("Waiting to catchup with leader... we are %d entries behind leader at %d.", new Object[]{gap, leaderCommitIndex});
        });
    }

    @Override
    public void joinedRaftGroup() {
        this.dual.info("Successfully joined the Raft group.");
    }
}

