/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.state.machines.tx.LastCommittedIndexFinder;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.logging.LogProvider;

public class RecoverConsensusLogIndex {
    private final LocalDatabase localDatabase;
    private final LogProvider logProvider;

    public RecoverConsensusLogIndex(LocalDatabase localDatabase, LogProvider logProvider) {
        this.localDatabase = localDatabase;
        this.logProvider = logProvider;
    }

    public long findLastAppliedIndex() {
        DependencyResolver dependencies = this.localDatabase.dataSource().getDependencyResolver();
        TransactionIdStore transactionIdStore = (TransactionIdStore)dependencies.resolveDependency(TransactionIdStore.class, DependencyResolver.SelectionStrategy.ONLY);
        LogicalTransactionStore transactionStore = (LogicalTransactionStore)dependencies.resolveDependency(LogicalTransactionStore.class, DependencyResolver.SelectionStrategy.ONLY);
        return new LastCommittedIndexFinder(transactionIdStore, transactionStore, this.logProvider).getLastCommittedIndex();
    }
}

