/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.token;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.neo4j.causalclustering.core.replication.ReplicationFailureException;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenCreator;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.core.AbstractTokenHolderBase;
import org.neo4j.kernel.impl.core.TokenRegistry;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class ReplicatedTokenHolder
extends AbstractTokenHolderBase {
    private final Replicator replicator;
    private final IdGeneratorFactory idGeneratorFactory;
    private final IdType tokenIdType;
    private final TokenType type;
    private final Supplier<StorageEngine> storageEngineSupplier;
    private final ReplicatedTokenCreator tokenCreator;

    ReplicatedTokenHolder(TokenRegistry tokenRegistry, Replicator replicator, IdGeneratorFactory idGeneratorFactory, IdType tokenIdType, Supplier<StorageEngine> storageEngineSupplier, TokenType type, ReplicatedTokenCreator tokenCreator) {
        super(tokenRegistry);
        this.replicator = replicator;
        this.idGeneratorFactory = idGeneratorFactory;
        this.tokenIdType = tokenIdType;
        this.type = type;
        this.storageEngineSupplier = storageEngineSupplier;
        this.tokenCreator = tokenCreator;
    }

    public void getOrCreateIds(String[] names, int[] ids) {
        for (int i = 0; i < names.length; ++i) {
            ids[i] = this.getOrCreateId(names[i]);
        }
    }

    protected int createToken(String tokenName) {
        ReplicatedTokenRequest tokenRequest = new ReplicatedTokenRequest(this.type, tokenName, this.createCommands(tokenName));
        try {
            Future<Object> future = this.replicator.replicate(tokenRequest, true);
            return (Integer)future.get();
        }
        catch (InterruptedException | ReplicationFailureException e) {
            throw new org.neo4j.graphdb.TransactionFailureException("Could not create token", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] createCommands(String tokenName) {
        StorageEngine storageEngine = this.storageEngineSupplier.get();
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
        TxState txState = new TxState();
        int tokenId = Math.toIntExact(this.idGeneratorFactory.get(this.tokenIdType).nextId());
        this.tokenCreator.createToken((TransactionState)txState, tokenName, tokenId);
        try (StorageReader statement = storageEngine.newReader();){
            storageEngine.createCommands(commands, (ReadableTransactionState)txState, statement, ResourceLocker.NONE, Long.MAX_VALUE, TxStateVisitor.NO_DECORATION);
        }
        catch (TransactionFailureException | ConstraintValidationException | CreateConstraintFailureException e) {
            throw new RuntimeException("Unable to create token '" + tokenName + "'", e);
        }
        return ReplicatedTokenRequestSerializer.commandBytes(commands);
    }
}

