/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.dummy;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.state.CommandDispatcher;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.tx.CoreReplicatedContent;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.ByteArrayByteBufAwareMarshal;
import org.neo4j.causalclustering.messaging.marshalling.ByteBufAwareMarshal;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class DummyRequest
implements CoreReplicatedContent {
    private final byte[] data;

    public DummyRequest(byte[] data) {
        this.data = data;
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public long size() {
        return this.data.length;
    }

    public long byteCount() {
        return this.data != null ? (long)this.data.length : 0L;
    }

    @Override
    public void dispatch(CommandDispatcher commandDispatcher, long commandIndex, Consumer<Result> callback) {
        commandDispatcher.dispatch(this, commandIndex, callback);
    }

    public ByteBufAwareMarshal serializer() {
        if (this.data != null) {
            return new ByteArrayByteBufAwareMarshal(this.data);
        }
        return ByteBufAwareMarshal.simple((ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> channel.putInt(0)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DummyRequest that = (DummyRequest)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public static class Marshal
    extends SafeChannelMarshal<DummyRequest> {
        public static final Marshal INSTANCE = new Marshal();

        @Override
        public void marshal(DummyRequest dummy, WritableChannel channel) throws IOException {
            if (dummy.data != null) {
                channel.putInt(dummy.data.length);
                channel.put(dummy.data, dummy.data.length);
            } else {
                channel.putInt(0);
            }
        }

        @Override
        protected DummyRequest unmarshal0(ReadableChannel channel) throws IOException {
            byte[] data;
            int length = channel.getInt();
            if (length > 0) {
                data = new byte[length];
                channel.get(data, length);
            } else {
                data = null;
            }
            return new DummyRequest(data);
        }
    }
}

