/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.IOException;
import org.neo4j.causalclustering.SessionTracker;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.state.CommandDispatcher;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachines;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateType;
import org.neo4j.causalclustering.core.state.storage.StateStorage;

public class CoreState {
    private CoreStateMachines coreStateMachines;
    private final SessionTracker sessionTracker;
    private final StateStorage<Long> lastFlushedStorage;

    public CoreState(CoreStateMachines coreStateMachines, SessionTracker sessionTracker, StateStorage<Long> lastFlushedStorage) {
        this.coreStateMachines = coreStateMachines;
        this.sessionTracker = sessionTracker;
        this.lastFlushedStorage = lastFlushedStorage;
    }

    synchronized void augmentSnapshot(CoreSnapshot coreSnapshot) {
        this.coreStateMachines.addSnapshots(coreSnapshot);
        coreSnapshot.add(CoreStateType.SESSION_TRACKER, this.sessionTracker.snapshot());
    }

    synchronized void installSnapshot(CoreSnapshot coreSnapshot) {
        this.coreStateMachines.installSnapshots(coreSnapshot);
        this.sessionTracker.installSnapshot((GlobalSessionTrackerState)coreSnapshot.get(CoreStateType.SESSION_TRACKER));
    }

    synchronized void flush(long lastApplied) throws IOException {
        this.coreStateMachines.flush();
        this.sessionTracker.flush();
        this.lastFlushedStorage.persistStoreData(lastApplied);
    }

    public CommandDispatcher commandDispatcher() {
        return this.coreStateMachines.commandDispatcher();
    }

    long getLastAppliedIndex() {
        return Long.max(this.coreStateMachines.getLastAppliedIndex(), this.sessionTracker.getLastAppliedIndex());
    }

    long getLastFlushed() {
        return this.lastFlushedStorage.getInitialState();
    }
}

