/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.Progress;
import org.neo4j.causalclustering.core.replication.ProgressTracker;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.core.state.Result;

public class ProgressTrackerImpl
implements ProgressTracker {
    private final Map<LocalOperationId, Progress> tracker = new ConcurrentHashMap<LocalOperationId, Progress>();
    private final GlobalSession myGlobalSession;

    public ProgressTrackerImpl(GlobalSession myGlobalSession) {
        this.myGlobalSession = myGlobalSession;
    }

    @Override
    public Progress start(DistributedOperation operation) {
        assert (operation.globalSession().equals(this.myGlobalSession));
        Progress progress = new Progress();
        this.tracker.put(operation.operationId(), progress);
        return progress;
    }

    @Override
    public void trackReplication(DistributedOperation operation) {
        if (!operation.globalSession().equals(this.myGlobalSession)) {
            return;
        }
        Progress progress = this.tracker.get(operation.operationId());
        if (progress != null) {
            progress.setReplicated();
        }
    }

    @Override
    public void trackResult(DistributedOperation operation, Result result) {
        if (!operation.globalSession().equals(this.myGlobalSession)) {
            return;
        }
        Progress progress = this.tracker.remove(operation.operationId());
        if (progress != null) {
            result.apply(progress.futureResult());
        }
    }

    @Override
    public void abort(DistributedOperation operation) {
        this.tracker.remove(operation.operationId());
    }

    @Override
    public void triggerReplicationEvent() {
        this.tracker.forEach((ignored, progress) -> progress.triggerReplicationEvent());
    }

    @Override
    public int inProgressCount() {
        return this.tracker.size();
    }
}

