/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.term;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.log.monitoring.RaftTermMonitor;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.kernel.monitoring.Monitors;

public class MonitoredTermStateStorage
implements StateStorage<TermState> {
    private String TERM_TAG = "term";
    private final StateStorage<TermState> delegate;
    private final RaftTermMonitor termMonitor;

    public MonitoredTermStateStorage(StateStorage<TermState> delegate, Monitors monitors) {
        this.delegate = delegate;
        this.termMonitor = (RaftTermMonitor)monitors.newMonitor(RaftTermMonitor.class, new String[]{this.getClass().getName(), this.TERM_TAG});
    }

    @Override
    public TermState getInitialState() {
        return this.delegate.getInitialState();
    }

    @Override
    public void persistStoreData(TermState state) throws IOException {
        this.delegate.persistStoreData(state);
        this.termMonitor.term(state.currentTerm());
    }
}

