/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.MajorityIncludingSelfQuorum;
import org.neo4j.causalclustering.core.consensus.RaftMessageHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Appending;
import org.neo4j.causalclustering.core.consensus.roles.Election;
import org.neo4j.causalclustering.core.consensus.roles.Heart;
import org.neo4j.causalclustering.core.consensus.roles.Pruning;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.roles.Voting;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.logging.Log;

class Follower
implements RaftMessageHandler {
    Follower() {
    }

    static boolean logHistoryMatches(ReadableRaftState ctx, long leaderSegmentPrevIndex, long leaderSegmentPrevTerm) throws IOException {
        long localLogPrevIndex = ctx.entryLog().prevIndex();
        long localSegmentPrevTerm = ctx.entryLog().readEntryTerm(leaderSegmentPrevIndex);
        return leaderSegmentPrevIndex > -1L && (leaderSegmentPrevIndex <= localLogPrevIndex || localSegmentPrevTerm == leaderSegmentPrevTerm);
    }

    static void commitToLogOnUpdate(ReadableRaftState ctx, long indexOfLastNewEntry, long leaderCommit, Outcome outcome) {
        long newCommitIndex = Long.min(leaderCommit, indexOfLastNewEntry);
        if (newCommitIndex > ctx.commitIndex()) {
            outcome.setCommitIndex(newCommitIndex);
        }
    }

    private static void handleLeaderLogCompaction(ReadableRaftState ctx, Outcome outcome, RaftMessages.LogCompactionInfo compactionInfo) {
        if (compactionInfo.leaderTerm() < ctx.term()) {
            return;
        }
        if (ctx.entryLog().appendIndex() <= -1L || compactionInfo.prevIndex() > ctx.entryLog().appendIndex()) {
            outcome.markNeedForFreshSnapshot();
        }
    }

    @Override
    public Outcome handle(RaftMessages.RaftMessage message, ReadableRaftState ctx, Log log) throws IOException {
        return message.dispatch(this.visitor(ctx, log));
    }

    private Handler visitor(ReadableRaftState ctx, Log log) {
        PreVoteRequestHandler preVoteRequestHandler;
        ElectionTimeoutHandler electionTimeoutHandler;
        PreVoteResponseHandler preVoteResponseHandler;
        if (ctx.refusesToBeLeader()) {
            preVoteResponseHandler = PreVoteResponseNoOpHandler.instance;
            if (ctx.supportPreVoting()) {
                electionTimeoutHandler = PreVoteSupportedRefusesToLeadHandler.instance;
                preVoteRequestHandler = ctx.isPreElection() ? PreVoteRequestVotingHandler.instance : PreVoteRequestDecliningHandler.instance;
            } else {
                preVoteRequestHandler = PreVoteRequestNoOpHandler.instance;
                electionTimeoutHandler = PreVoteUnsupportedRefusesToLead.instance;
            }
        } else if (ctx.supportPreVoting()) {
            electionTimeoutHandler = PreVoteSupportedHandler.instance;
            if (ctx.isPreElection()) {
                preVoteRequestHandler = PreVoteRequestVotingHandler.instance;
                preVoteResponseHandler = PreVoteResponseSolicitingHandler.instance;
            } else {
                preVoteRequestHandler = PreVoteRequestDecliningHandler.instance;
                preVoteResponseHandler = PreVoteResponseNoOpHandler.instance;
            }
        } else {
            preVoteRequestHandler = PreVoteRequestNoOpHandler.instance;
            preVoteResponseHandler = PreVoteResponseNoOpHandler.instance;
            electionTimeoutHandler = PreVoteUnsupportedHandler.instance;
        }
        return new Handler(preVoteRequestHandler, preVoteResponseHandler, electionTimeoutHandler, ctx, log);
    }

    private static class PreVoteResponseNoOpHandler
    implements PreVoteResponseHandler {
        private static PreVoteResponseHandler instance = new PreVoteResponseNoOpHandler();

        private PreVoteResponseNoOpHandler() {
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Response response, Outcome outcome, ReadableRaftState ctx, Log log) {
            return outcome;
        }
    }

    private static class PreVoteResponseSolicitingHandler
    implements PreVoteResponseHandler {
        private static PreVoteResponseHandler instance = new PreVoteResponseSolicitingHandler();

        private PreVoteResponseSolicitingHandler() {
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Response res, Outcome outcome, ReadableRaftState ctx, Log log) throws IOException {
            if (res.term() > ctx.term()) {
                outcome.setNextTerm(res.term());
                outcome.setPreElection(false);
                log.info("Aborting pre-election after receiving pre-vote response from %s at term %d (I am at %d)", new Object[]{res.from(), res.term(), ctx.term()});
                return outcome;
            }
            if (res.term() < ctx.term() || !res.voteGranted()) {
                return outcome;
            }
            if (!res.from().equals(ctx.myself())) {
                outcome.addPreVoteForMe(res.from());
            }
            if (MajorityIncludingSelfQuorum.isQuorum(ctx.votingMembers(), outcome.getPreVotesForMe())) {
                outcome.renewElectionTimeout();
                outcome.setPreElection(false);
                if (Election.startRealElection(ctx, outcome, log)) {
                    outcome.setNextRole(Role.CANDIDATE);
                    log.info("Moving to CANDIDATE state after successful pre-election stage");
                }
            }
            return outcome;
        }
    }

    private static class PreVoteRequestNoOpHandler
    implements PreVoteRequestHandler {
        private static PreVoteRequestHandler instance = new PreVoteRequestNoOpHandler();

        private PreVoteRequestNoOpHandler() {
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Request request, Outcome outcome, ReadableRaftState ctx, Log log) {
            return outcome;
        }
    }

    private static class PreVoteRequestDecliningHandler
    implements PreVoteRequestHandler {
        private static PreVoteRequestHandler instance = new PreVoteRequestDecliningHandler();

        private PreVoteRequestDecliningHandler() {
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Request request, Outcome outcome, ReadableRaftState ctx, Log log) throws IOException {
            Voting.declinePreVoteRequest(ctx, outcome, request);
            return outcome;
        }
    }

    private static class PreVoteRequestVotingHandler
    implements PreVoteRequestHandler {
        private static PreVoteRequestHandler instance = new PreVoteRequestVotingHandler();

        private PreVoteRequestVotingHandler() {
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Request request, Outcome outcome, ReadableRaftState ctx, Log log) throws IOException {
            Voting.handlePreVoteRequest(ctx, outcome, request, log);
            return outcome;
        }
    }

    private static class PreVoteSupportedRefusesToLeadHandler
    implements ElectionTimeoutHandler {
        private static ElectionTimeoutHandler instance = new PreVoteSupportedRefusesToLeadHandler();

        private PreVoteSupportedRefusesToLeadHandler() {
        }

        @Override
        public Outcome handle(RaftMessages.Timeout.Election election, Outcome outcome, ReadableRaftState ctx, Log log) {
            log.info("Election timeout triggered but refusing to be leader");
            Set<MemberId> memberIds = ctx.votingMembers();
            if (memberIds != null && memberIds.contains(ctx.myself())) {
                outcome.setPreElection(true);
            }
            return outcome;
        }
    }

    private static class PreVoteUnsupportedRefusesToLead
    implements ElectionTimeoutHandler {
        private static ElectionTimeoutHandler instance = new PreVoteUnsupportedRefusesToLead();

        private PreVoteUnsupportedRefusesToLead() {
        }

        @Override
        public Outcome handle(RaftMessages.Timeout.Election election, Outcome outcome, ReadableRaftState ctx, Log log) {
            log.info("Election timeout triggered but refusing to be leader");
            return outcome;
        }
    }

    private static class PreVoteUnsupportedHandler
    implements ElectionTimeoutHandler {
        private static ElectionTimeoutHandler instance = new PreVoteUnsupportedHandler();

        private PreVoteUnsupportedHandler() {
        }

        @Override
        public Outcome handle(RaftMessages.Timeout.Election election, Outcome outcome, ReadableRaftState ctx, Log log) throws IOException {
            log.info("Election timeout triggered");
            if (Election.startRealElection(ctx, outcome, log)) {
                outcome.setNextRole(Role.CANDIDATE);
                log.info("Moving to CANDIDATE state after successfully starting election");
            }
            return outcome;
        }
    }

    private static class PreVoteSupportedHandler
    implements ElectionTimeoutHandler {
        private static ElectionTimeoutHandler instance = new PreVoteSupportedHandler();

        private PreVoteSupportedHandler() {
        }

        @Override
        public Outcome handle(RaftMessages.Timeout.Election election, Outcome outcome, ReadableRaftState ctx, Log log) throws IOException {
            log.info("Election timeout triggered");
            if (Election.startPreElection(ctx, outcome, log)) {
                outcome.setPreElection(true);
            }
            return outcome;
        }
    }

    private static interface PreVoteResponseHandler {
        public Outcome handle(RaftMessages.PreVote.Response var1, Outcome var2, ReadableRaftState var3, Log var4) throws IOException;
    }

    private static interface PreVoteRequestHandler {
        public Outcome handle(RaftMessages.PreVote.Request var1, Outcome var2, ReadableRaftState var3, Log var4) throws IOException;
    }

    private static interface ElectionTimeoutHandler {
        public Outcome handle(RaftMessages.Timeout.Election var1, Outcome var2, ReadableRaftState var3, Log var4) throws IOException;
    }

    private static class Handler
    implements RaftMessages.Handler<Outcome, IOException> {
        protected final ReadableRaftState ctx;
        protected final Log log;
        protected final Outcome outcome;
        private final PreVoteRequestHandler preVoteRequestHandler;
        private final PreVoteResponseHandler preVoteResponseHandler;
        private final ElectionTimeoutHandler electionTimeoutHandler;

        Handler(PreVoteRequestHandler preVoteRequestHandler, PreVoteResponseHandler preVoteResponseHandler, ElectionTimeoutHandler electionTimeoutHandler, ReadableRaftState ctx, Log log) {
            this.ctx = ctx;
            this.log = log;
            this.outcome = new Outcome(Role.FOLLOWER, ctx);
            this.preVoteRequestHandler = preVoteRequestHandler;
            this.preVoteResponseHandler = preVoteResponseHandler;
            this.electionTimeoutHandler = electionTimeoutHandler;
        }

        @Override
        public Outcome handle(RaftMessages.Heartbeat heartbeat) throws IOException {
            Heart.beat(this.ctx, this.outcome, heartbeat, this.log);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.AppendEntries.Request request) throws IOException {
            Appending.handleAppendEntriesRequest(this.ctx, this.outcome, request, this.log);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.Vote.Request request) throws IOException {
            Voting.handleVoteRequest(this.ctx, this.outcome, request, this.log);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.LogCompactionInfo logCompactionInfo) {
            Follower.handleLeaderLogCompaction(this.ctx, this.outcome, logCompactionInfo);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.Vote.Response response) {
            this.log.info("Late vote response: %s", new Object[]{response});
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Request request) throws IOException {
            return this.preVoteRequestHandler.handle(request, this.outcome, this.ctx, this.log);
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Response response) throws IOException {
            return this.preVoteResponseHandler.handle(response, this.outcome, this.ctx, this.log);
        }

        @Override
        public Outcome handle(RaftMessages.PruneRequest pruneRequest) {
            Pruning.handlePruneRequest(this.outcome, pruneRequest);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.AppendEntries.Response response) {
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.HeartbeatResponse heartbeatResponse) {
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.Timeout.Election election) throws IOException {
            return this.electionTimeoutHandler.handle(election, this.outcome, this.ctx, this.log);
        }

        @Override
        public Outcome handle(RaftMessages.Timeout.Heartbeat heartbeat) {
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.NewEntry.Request request) {
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.NewEntry.BatchRequest batchRequest) {
            return this.outcome;
        }
    }
}

