/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.protocol.v2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.marshalling.v2.encoding.ContentTypeEncoder;
import org.neo4j.causalclustering.messaging.marshalling.v2.encoding.RaftLogEntryTermEncoder;
import org.neo4j.causalclustering.messaging.marshalling.v2.encoding.RaftMessageContentSerializer;
import org.neo4j.causalclustering.messaging.marshalling.v2.encoding.RaftMessageEncoder;
import org.neo4j.causalclustering.protocol.ClientNettyPipelineBuilder;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RaftProtocolClientInstallerV2
implements ProtocolInstaller<ProtocolInstaller.Orientation.Client> {
    private static final Protocol.ApplicationProtocols APPLICATION_PROTOCOL = Protocol.ApplicationProtocols.RAFT_2;
    private final List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Client>> modifiers;
    private final Log log;
    private final NettyPipelineBuilderFactory clientPipelineBuilderFactory;

    public RaftProtocolClientInstallerV2(NettyPipelineBuilderFactory clientPipelineBuilderFactory, List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Client>> modifiers, LogProvider logProvider) {
        this.modifiers = modifiers;
        this.log = logProvider.getLog(this.getClass());
        this.clientPipelineBuilderFactory = clientPipelineBuilderFactory;
    }

    @Override
    public void install(Channel channel) throws Exception {
        ((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)this.clientPipelineBuilderFactory.client(channel, this.log).modify(this.modifiers)).addFraming().add("raft_message_encoder", new ChannelHandler[]{new RaftMessageEncoder()})).add("raft_content_type_encoder", new ChannelHandler[]{new ContentTypeEncoder()})).add("raft_chunked_writer", new ChannelHandler[]{new ChunkedWriteHandler()})).add("raft_log_entry_encoder", new ChannelHandler[]{new RaftLogEntryTermEncoder()})).add("raft_message_content_encoder", new ChannelHandler[]{new RaftMessageContentSerializer(new CoreReplicatedContentMarshal())})).install();
    }

    @Override
    public Protocol.ApplicationProtocol applicationProtocol() {
        return APPLICATION_PROTOCOL;
    }

    @Override
    public Collection<Collection<Protocol.ModifierProtocol>> modifiers() {
        return this.modifiers.stream().map(ModifierProtocolInstaller::protocols).collect(Collectors.toList());
    }

    public static class Factory
    extends ProtocolInstaller.Factory<ProtocolInstaller.Orientation.Client, RaftProtocolClientInstallerV2> {
        public Factory(NettyPipelineBuilderFactory clientPipelineBuilderFactory, LogProvider logProvider) {
            super(APPLICATION_PROTOCOL, (List<ModifierProtocolInstaller<O>> modifiers) -> new RaftProtocolClientInstallerV2(clientPipelineBuilderFactory, (List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Client>>)modifiers, logProvider));
        }
    }
}

