/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.protocol.v1;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.marshalling.v1.RaftMessageDecoder;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ServerNettyPipelineBuilder;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RaftProtocolServerInstallerV1
implements ProtocolInstaller<ProtocolInstaller.Orientation.Server> {
    private static final Protocol.ApplicationProtocols APPLICATION_PROTOCOL = Protocol.ApplicationProtocols.RAFT_1;
    private final ChannelInboundHandler raftMessageHandler;
    private final NettyPipelineBuilderFactory pipelineBuilderFactory;
    private final List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Server>> modifiers;
    private final Log log;

    public RaftProtocolServerInstallerV1(ChannelInboundHandler raftMessageHandler, NettyPipelineBuilderFactory pipelineBuilderFactory, List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Server>> modifiers, LogProvider logProvider) {
        this.raftMessageHandler = raftMessageHandler;
        this.pipelineBuilderFactory = pipelineBuilderFactory;
        this.modifiers = modifiers;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void install(Channel channel) throws Exception {
        ((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)((ServerNettyPipelineBuilder)this.pipelineBuilderFactory.server(channel, this.log).modify(this.modifiers)).addFraming().add("raft_decoder", new ChannelHandler[]{new RaftMessageDecoder(new CoreReplicatedContentMarshal(), Clock.systemUTC())})).add("raft_handler", new ChannelHandler[]{this.raftMessageHandler})).install();
    }

    @Override
    public Protocol.ApplicationProtocol applicationProtocol() {
        return APPLICATION_PROTOCOL;
    }

    @Override
    public Collection<Collection<Protocol.ModifierProtocol>> modifiers() {
        return this.modifiers.stream().map(ModifierProtocolInstaller::protocols).collect(Collectors.toList());
    }

    public static class Factory
    extends ProtocolInstaller.Factory<ProtocolInstaller.Orientation.Server, RaftProtocolServerInstallerV1> {
        public Factory(ChannelInboundHandler raftMessageHandler, NettyPipelineBuilderFactory pipelineBuilderFactory, LogProvider logProvider) {
            super(APPLICATION_PROTOCOL, modifiers -> new RaftProtocolServerInstallerV1(raftMessageHandler, pipelineBuilderFactory, (List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Server>>)modifiers, logProvider));
        }
    }
}

