/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import org.neo4j.causalclustering.core.consensus.log.EntryRecord;
import org.neo4j.causalclustering.core.consensus.log.segmented.DamagedLogStorageException;
import org.neo4j.causalclustering.core.consensus.log.segmented.DisposedException;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.causalclustering.core.consensus.log.segmented.RecoveryProtocol;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentFile;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentHeader;
import org.neo4j.causalclustering.core.consensus.log.segmented.Segments;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;
import org.neo4j.cursor.IOCursor;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

class DumpSegmentedRaftLog {
    private final FileSystemAbstraction fileSystem;
    private static final String TO_FILE = "tofile";
    private ChannelMarshal<ReplicatedContent> marshal;
    private static final Printer SYSTEM_OUT_PRINTER = new Printer(){

        @Override
        public PrintStream getFor(String file) {
            return System.out;
        }

        @Override
        public void close() {
        }
    };

    private DumpSegmentedRaftLog(FileSystemAbstraction fileSystem, ChannelMarshal<ReplicatedContent> marshal) {
        this.fileSystem = fileSystem;
        this.marshal = marshal;
    }

    private int dump(String filenameOrDirectory, PrintStream out) throws IOException, DamagedLogStorageException, DisposedException {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        int[] logsFound = new int[]{0};
        FileNames fileNames = new FileNames(new File(filenameOrDirectory));
        ReaderPool readerPool = new ReaderPool(0, (LogProvider)logProvider, fileNames, this.fileSystem, Clocks.systemClock());
        RecoveryProtocol recoveryProtocol = new RecoveryProtocol(this.fileSystem, fileNames, readerPool, this.marshal, (LogProvider)logProvider);
        Segments segments = recoveryProtocol.run().segments;
        segments.visit((Visitor<SegmentFile, RuntimeException>)((Visitor)segment -> {
            logsFound[0] = logsFound[0] + 1;
            out.println("=== " + segment.getFilename() + " ===");
            SegmentHeader header = segment.header();
            out.println(header.toString());
            try (IOCursor<EntryRecord> cursor = segment.getCursor(header.prevIndex() + 1L);){
                while (cursor.next()) {
                    out.println(((EntryRecord)cursor.get()).toString());
                }
            }
            catch (IOException | DisposedException e) {
                e.printStackTrace();
                System.exit(-1);
                return true;
            }
            return false;
        }));
        return logsFound[0];
    }

    public static void main(String[] args) {
        Args arguments = Args.withFlags((String[])new String[]{TO_FILE}).parse(args);
        try (Printer printer = DumpSegmentedRaftLog.getPrinter(arguments);){
            for (String fileAsString : arguments.orphans()) {
                System.out.println("Reading file " + fileAsString);
                try {
                    DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
                    Throwable throwable = null;
                    try {
                        new DumpSegmentedRaftLog((FileSystemAbstraction)fileSystem, new CoreReplicatedContentMarshal()).dump(fileAsString, printer.getFor(fileAsString));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileSystem == null) continue;
                        if (throwable != null) {
                            try {
                                fileSystem.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileSystem.close();
                    }
                }
                catch (IOException | DamagedLogStorageException | DisposedException e) {
                    ((Throwable)e).printStackTrace();
                }
            }
        }
    }

    private static Printer getPrinter(Args args) {
        boolean toFile = args.getBoolean(TO_FILE, Boolean.valueOf(false), Boolean.valueOf(true));
        return toFile ? new FilePrinter() : SYSTEM_OUT_PRINTER;
    }

    private static class FilePrinter
    implements Printer {
        private File directory;
        private PrintStream out;

        private FilePrinter() {
        }

        @Override
        public PrintStream getFor(String file) throws FileNotFoundException {
            File dir;
            File absoluteFile = new File(file).getAbsoluteFile();
            File file2 = dir = absoluteFile.isDirectory() ? absoluteFile : absoluteFile.getParentFile();
            if (!dir.equals(this.directory)) {
                this.close();
                File dumpFile = new File(dir, "dump-logical-log.txt");
                System.out.println("Redirecting the output to " + dumpFile.getPath());
                this.out = new PrintStream(dumpFile);
                this.directory = dir;
            }
            return this.out;
        }

        @Override
        public void close() {
            if (this.out != null) {
                this.out.close();
            }
        }
    }

    static interface Printer
    extends AutoCloseable {
        public PrintStream getFor(String var1) throws FileNotFoundException;

        @Override
        public void close();
    }
}

