/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.util.Objects;
import java.util.function.LongPredicate;
import org.neo4j.helpers.collection.LruCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class RaftLogMetadataCache {
    private final LruCache<Long, RaftLogEntryMetadata> raftLogEntryCache;

    public RaftLogMetadataCache(int logEntryCacheSize) {
        this.raftLogEntryCache = new LruCache("Raft log entry cache", logEntryCacheSize);
    }

    public void clear() {
        this.raftLogEntryCache.clear();
    }

    public RaftLogEntryMetadata getMetadata(long logIndex) {
        return (RaftLogEntryMetadata)this.raftLogEntryCache.get((Object)logIndex);
    }

    public RaftLogEntryMetadata cacheMetadata(long logIndex, long entryTerm, LogPosition position) {
        RaftLogEntryMetadata result = new RaftLogEntryMetadata(entryTerm, position);
        this.raftLogEntryCache.put((Object)logIndex, (Object)result);
        return result;
    }

    public void removeUpTo(long upTo) {
        this.remove(key -> key <= upTo);
    }

    public void removeUpwardsFrom(long startingFrom) {
        this.remove(key -> key >= startingFrom);
    }

    private void remove(LongPredicate predicate) {
        this.raftLogEntryCache.keySet().removeIf(predicate::test);
    }

    public static class RaftLogEntryMetadata {
        private final long entryTerm;
        private final LogPosition startPosition;

        public RaftLogEntryMetadata(long entryTerm, LogPosition startPosition) {
            Objects.requireNonNull(startPosition);
            this.entryTerm = entryTerm;
            this.startPosition = startPosition;
        }

        public long getEntryTerm() {
            return this.entryTerm;
        }

        public LogPosition getStartPosition() {
            return this.startPosition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RaftLogEntryMetadata that = (RaftLogEntryMetadata)o;
            if (this.entryTerm != that.entryTerm) {
                return false;
            }
            return this.startPosition.equals((Object)that.startPosition);
        }

        public int hashCode() {
            int result = (int)(this.entryTerm ^ this.entryTerm >>> 32);
            result = 31 * result + this.startPosition.hashCode();
            return result;
        }

        public String toString() {
            return "RaftLogEntryMetadata{entryTerm=" + this.entryTerm + ", startPosition=" + this.startPosition + '}';
        }
    }
}

