/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.neo4j.causalclustering.core.consensus.CoreMetaData;
import org.neo4j.causalclustering.core.consensus.LeaderAvailabilityTimers;
import org.neo4j.causalclustering.core.consensus.LeaderContext;
import org.neo4j.causalclustering.core.consensus.LeaderListener;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.LeaderNotFoundMonitor;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipManager;
import org.neo4j.causalclustering.core.consensus.outcome.ConsensusOutcome;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.causalclustering.core.consensus.shipping.RaftLogShippingManager;
import org.neo4j.causalclustering.core.consensus.state.ExposedRaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.consensus.vote.VoteState;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.helper.VolatileFuture;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RaftMachine
implements LeaderLocator,
CoreMetaData {
    private final LeaderNotFoundMonitor leaderNotFoundMonitor;
    private InFlightCache inFlightCache;
    private final RaftState state;
    private final MemberId myself;
    private final LeaderAvailabilityTimers leaderAvailabilityTimers;
    private RaftMembershipManager membershipManager;
    private final VolatileFuture<MemberId> volatileLeader = new VolatileFuture<Object>(null);
    private final Outbound<MemberId, RaftMessages.RaftMessage> outbound;
    private final Log log;
    private Role currentRole = Role.FOLLOWER;
    private RaftLogShippingManager logShipping;
    private Collection<LeaderListener> leaderListeners = new ArrayList<LeaderListener>();

    public RaftMachine(MemberId myself, StateStorage<TermState> termStorage, StateStorage<VoteState> voteStorage, RaftLog entryLog, LeaderAvailabilityTimers leaderAvailabilityTimers, Outbound<MemberId, RaftMessages.RaftMessage> outbound, LogProvider logProvider, RaftMembershipManager membershipManager, RaftLogShippingManager logShipping, InFlightCache inFlightCache, boolean refuseToBecomeLeader, boolean supportPreVoting, Monitors monitors) {
        this.myself = myself;
        this.leaderAvailabilityTimers = leaderAvailabilityTimers;
        this.outbound = outbound;
        this.logShipping = logShipping;
        this.log = logProvider.getLog(this.getClass());
        this.membershipManager = membershipManager;
        this.inFlightCache = inFlightCache;
        this.state = new RaftState(myself, termStorage, membershipManager, entryLog, voteStorage, inFlightCache, logProvider, supportPreVoting, refuseToBecomeLeader);
        this.leaderNotFoundMonitor = (LeaderNotFoundMonitor)monitors.newMonitor(LeaderNotFoundMonitor.class, new String[0]);
    }

    public synchronized void postRecoveryActions() {
        this.leaderAvailabilityTimers.start((ThrowingConsumer<Clock, Exception>)((ThrowingConsumer)this::electionTimeout), (ThrowingConsumer<Clock, Exception>)((ThrowingConsumer)clock -> this.handle(RaftMessages.ReceivedInstantAwareMessage.of(clock.instant(), new RaftMessages.Timeout.Heartbeat(this.myself)))));
        this.inFlightCache.enable();
    }

    public synchronized void stopTimers() {
        this.leaderAvailabilityTimers.stop();
    }

    private synchronized void electionTimeout(Clock clock) throws IOException {
        if (this.leaderAvailabilityTimers.isElectionTimedOut()) {
            this.triggerElection(clock);
        }
    }

    public void triggerElection(Clock clock) throws IOException {
        this.handle(RaftMessages.ReceivedInstantAwareMessage.of(clock.instant(), new RaftMessages.Timeout.Election(this.myself)));
    }

    public void panic() {
        this.stopTimers();
    }

    public synchronized RaftCoreState coreState() {
        return new RaftCoreState(this.membershipManager.getCommitted());
    }

    public synchronized void installCoreState(RaftCoreState coreState) throws IOException {
        this.membershipManager.install(coreState.committed());
    }

    public synchronized void setTargetMembershipSet(Set<MemberId> targetMembers) {
        this.membershipManager.setTargetMembershipSet(targetMembers);
        if (this.currentRole == Role.LEADER) {
            this.membershipManager.onFollowerStateChange(this.state.followerStates());
        }
    }

    @Override
    public MemberId getLeader() throws NoLeaderFoundException {
        return this.waitForLeader(0L, Objects::nonNull);
    }

    private MemberId waitForLeader(long timeoutMillis, Predicate<MemberId> predicate) throws NoLeaderFoundException {
        try {
            return this.volatileLeader.get(timeoutMillis, predicate);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.leaderNotFoundMonitor.increment();
            throw new NoLeaderFoundException(e);
        }
        catch (TimeoutException e) {
            this.leaderNotFoundMonitor.increment();
            throw new NoLeaderFoundException(e);
        }
    }

    @Override
    public synchronized void registerListener(LeaderListener listener) {
        this.leaderListeners.add(listener);
        listener.onLeaderSwitch(this.state.leaderInfo());
    }

    @Override
    public synchronized void unregisterListener(LeaderListener listener) {
        this.leaderListeners.remove(listener);
    }

    public synchronized ExposedRaftState state() {
        return this.state.copy();
    }

    private void notifyLeaderChanges(Outcome outcome) {
        for (LeaderListener listener : this.leaderListeners) {
            listener.onLeaderEvent(outcome);
        }
    }

    private void handleLogShipping(Outcome outcome) {
        LeaderContext leaderContext = new LeaderContext(outcome.getTerm(), outcome.getLeaderCommit());
        if (outcome.isElectedLeader()) {
            this.logShipping.resume(leaderContext);
        } else if (outcome.isSteppingDown()) {
            this.logShipping.pause();
        }
        if (outcome.getRole() == Role.LEADER) {
            this.logShipping.handleCommands(outcome.getShipCommands(), leaderContext);
        }
    }

    private boolean leaderChanged(Outcome outcome, MemberId oldLeader) {
        return !Objects.equals(oldLeader, outcome.getLeader());
    }

    public synchronized ConsensusOutcome handle(RaftMessages.RaftMessage incomingMessage) throws IOException {
        Outcome outcome = this.currentRole.handler.handle(incomingMessage, this.state, this.log);
        boolean newLeaderWasElected = this.leaderChanged(outcome, this.state.leader());
        this.state.update(outcome);
        this.sendMessages(outcome);
        this.handleTimers(outcome);
        this.handleLogShipping(outcome);
        this.driveMembership(outcome);
        this.volatileLeader.set(outcome.getLeader());
        if (newLeaderWasElected) {
            this.notifyLeaderChanges(outcome);
        }
        return outcome;
    }

    private void driveMembership(Outcome outcome) throws IOException {
        this.membershipManager.processLog(outcome.getCommitIndex(), outcome.getLogCommands());
        this.currentRole = outcome.getRole();
        this.membershipManager.onRole(this.currentRole);
        if (this.currentRole == Role.LEADER) {
            this.membershipManager.onFollowerStateChange(this.state.followerStates());
        }
    }

    private void handleTimers(Outcome outcome) {
        if (outcome.electionTimeoutRenewed()) {
            this.leaderAvailabilityTimers.renewElection();
        }
    }

    private void sendMessages(Outcome outcome) {
        for (RaftMessages.Directed outgoingMessage : outcome.getOutgoingMessages()) {
            try {
                this.outbound.send(outgoingMessage.to(), outgoingMessage.message());
            }
            catch (Exception e) {
                this.log.warn(String.format("Failed to send message %s.", outgoingMessage), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isLeader() {
        return this.currentRole == Role.LEADER;
    }

    public Role currentRole() {
        return this.currentRole;
    }

    public MemberId identity() {
        return this.myself;
    }

    public RaftLogShippingManager logShippingManager() {
        return this.logShipping;
    }

    public String toString() {
        return String.format("RaftInstance{role=%s, term=%d, currentMembers=%s}", new Object[]{this.currentRole, this.term(), this.votingMembers()});
    }

    public long term() {
        return this.state.term();
    }

    public Set<MemberId> votingMembers() {
        return this.membershipManager.votingMembers();
    }

    public Set<MemberId> replicationMembers() {
        return this.membershipManager.replicationMembers();
    }

    public static enum Timeouts implements TimerService.TimerName
    {
        ELECTION,
        HEARTBEAT;

    }
}

