/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.util.function.LongSupplier;
import org.neo4j.causalclustering.core.consensus.LeaderAvailabilityTimers;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.messaging.ComposableMessageHandler;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;

public class LeaderAvailabilityHandler
implements LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> {
    private final LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> delegateHandler;
    private final LeaderAvailabilityTimers leaderAvailabilityTimers;
    private final ShouldRenewElectionTimeout shouldRenewElectionTimeout;

    public LeaderAvailabilityHandler(LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> delegateHandler, LeaderAvailabilityTimers leaderAvailabilityTimers, LongSupplier term) {
        this.delegateHandler = delegateHandler;
        this.leaderAvailabilityTimers = leaderAvailabilityTimers;
        this.shouldRenewElectionTimeout = new ShouldRenewElectionTimeout(term);
    }

    public static ComposableMessageHandler composable(LeaderAvailabilityTimers leaderAvailabilityTimers, LongSupplier term) {
        return delegate -> new LeaderAvailabilityHandler(delegate, leaderAvailabilityTimers, term);
    }

    @Override
    public synchronized void start(ClusterId clusterId) throws Throwable {
        this.delegateHandler.start(clusterId);
    }

    @Override
    public synchronized void stop() throws Throwable {
        this.delegateHandler.stop();
    }

    @Override
    public void handle(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> message) {
        this.handleTimeouts(message);
        this.delegateHandler.handle(message);
    }

    private void handleTimeouts(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> message) {
        if (message.dispatch(this.shouldRenewElectionTimeout).booleanValue()) {
            this.leaderAvailabilityTimers.renewElection();
        }
    }

    private static class ShouldRenewElectionTimeout
    implements RaftMessages.Handler<Boolean, RuntimeException> {
        private final LongSupplier term;

        private ShouldRenewElectionTimeout(LongSupplier term) {
            this.term = term;
        }

        @Override
        public Boolean handle(RaftMessages.AppendEntries.Request request) {
            return request.leaderTerm() >= this.term.getAsLong();
        }

        @Override
        public Boolean handle(RaftMessages.Heartbeat heartbeat) {
            return heartbeat.leaderTerm() >= this.term.getAsLong();
        }

        @Override
        public Boolean handle(RaftMessages.Vote.Request request) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.Vote.Response response) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.PreVote.Request request) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.PreVote.Response response) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.AppendEntries.Response response) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.LogCompactionInfo logCompactionInfo) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.HeartbeatResponse heartbeatResponse) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.Timeout.Election election) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.Timeout.Heartbeat heartbeat) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.NewEntry.Request request) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.NewEntry.BatchRequest batchRequest) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean handle(RaftMessages.PruneRequest pruneRequest) {
            return Boolean.FALSE;
        }
    }
}

