/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import io.netty.channel.ChannelInboundHandler;
import java.util.Collection;
import java.util.Optional;
import org.neo4j.causalclustering.catchup.CatchupServerBuilder;
import org.neo4j.causalclustering.catchup.CatchupServerHandler;
import org.neo4j.causalclustering.core.HostnamePortAsListenAddress;
import org.neo4j.causalclustering.net.Server;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.logging.LogProvider;

public class TransactionBackupServiceProvider {
    private final LogProvider logProvider;
    private final LogProvider userLogProvider;
    private final ChannelInboundHandler parentHandler;
    private final ApplicationSupportedProtocols catchupProtocols;
    private final Collection<ModifierSupportedProtocols> supportedModifierProtocols;
    private final NettyPipelineBuilderFactory serverPipelineBuilderFactory;
    private final CatchupServerHandler catchupServerHandler;

    public TransactionBackupServiceProvider(LogProvider logProvider, LogProvider userLogProvider, ApplicationSupportedProtocols catchupProtocols, Collection<ModifierSupportedProtocols> supportedModifierProtocols, NettyPipelineBuilderFactory serverPipelineBuilderFactory, CatchupServerHandler catchupServerHandler, ChannelInboundHandler parentHandler) {
        this.logProvider = logProvider;
        this.userLogProvider = userLogProvider;
        this.parentHandler = parentHandler;
        this.catchupProtocols = catchupProtocols;
        this.supportedModifierProtocols = supportedModifierProtocols;
        this.serverPipelineBuilderFactory = serverPipelineBuilderFactory;
        this.catchupServerHandler = catchupServerHandler;
    }

    public Optional<Server> resolveIfBackupEnabled(Config config) {
        if (((Boolean)config.get(OnlineBackupSettings.online_backup_enabled)).booleanValue()) {
            ListenSocketAddress backupAddress = HostnamePortAsListenAddress.resolve(config, (Setting<HostnamePort>)OnlineBackupSettings.online_backup_server);
            this.logProvider.getLog(TransactionBackupServiceProvider.class).info("Binding backup service on address %s", new Object[]{backupAddress});
            return Optional.of(new CatchupServerBuilder(this.catchupServerHandler).serverHandler(this.parentHandler).catchupProtocols(this.catchupProtocols).modifierProtocols(this.supportedModifierProtocols).pipelineBuilder(this.serverPipelineBuilderFactory).userLogProvider(this.userLogProvider).debugLogProvider(this.logProvider).listenAddress(backupAddress).serverName("backup-server").build());
        }
        return Optional.empty();
    }
}

