/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.stream.Streams;

public class SupportedProtocolCreator {
    private final Config config;
    private final Log log;

    public SupportedProtocolCreator(Config config, LogProvider logProvider) {
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
    }

    public ApplicationSupportedProtocols createSupportedCatchupProtocol() {
        return this.getApplicationSupportedProtocols((List)this.config.get(CausalClusteringSettings.catchup_implementations), Protocol.ApplicationProtocolCategory.CATCHUP);
    }

    public ApplicationSupportedProtocols createSupportedRaftProtocol() {
        return this.getApplicationSupportedProtocols((List)this.config.get(CausalClusteringSettings.raft_implementations), Protocol.ApplicationProtocolCategory.RAFT);
    }

    private ApplicationSupportedProtocols getApplicationSupportedProtocols(List<Integer> configVersions, Protocol.ApplicationProtocolCategory category) {
        if (configVersions.isEmpty()) {
            return new ApplicationSupportedProtocols(category, Collections.emptyList());
        }
        List<Integer> knownVersions = this.protocolsForConfig(category, configVersions, version -> Protocol.ApplicationProtocols.find(category, version));
        if (knownVersions.isEmpty()) {
            throw new IllegalArgumentException(String.format("None of configured %s implementations %s are known", category.canonicalName(), configVersions));
        }
        return new ApplicationSupportedProtocols(category, knownVersions);
    }

    public List<ModifierSupportedProtocols> createSupportedModifierProtocols() {
        ModifierSupportedProtocols supportedCompression = this.compressionProtocolVersions();
        return Stream.of(supportedCompression).filter(supportedProtocols -> !supportedProtocols.versions().isEmpty()).collect(Collectors.toList());
    }

    private ModifierSupportedProtocols compressionProtocolVersions() {
        List<String> implementations = this.protocolsForConfig(Protocol.ModifierProtocolCategory.COMPRESSION, (List)this.config.get(CausalClusteringSettings.compression_implementations), implementation -> Protocol.ModifierProtocols.find(Protocol.ModifierProtocolCategory.COMPRESSION, implementation));
        return new ModifierSupportedProtocols(Protocol.ModifierProtocolCategory.COMPRESSION, implementations);
    }

    private <IMPL extends Comparable<IMPL>, T extends Protocol<IMPL>> List<IMPL> protocolsForConfig(Protocol.Category<T> category, List<IMPL> implementations, Function<IMPL, Optional<T>> finder) {
        return implementations.stream().map(impl -> Pair.of((Object)impl, finder.apply(impl))).peek(protocolWithImplementation -> this.logUnknownProtocol(category, (Pair)protocolWithImplementation)).map(Pair::other).flatMap(Streams::ofOptional).map(Protocol::implementation).collect(Collectors.toList());
    }

    private <IMPL extends Comparable<IMPL>, T extends Protocol<IMPL>> void logUnknownProtocol(Protocol.Category<T> category, Pair<IMPL, Optional<T>> protocolWithImplementation) {
        if (!((Optional)protocolWithImplementation.other()).isPresent()) {
            this.log.warn("Configured %s protocol implementation %s unknown. Ignoring.", new Object[]{category, protocolWithImplementation.first()});
        }
    }
}

