/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import java.util.concurrent.CompletableFuture;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.causalclustering.catchup.CatchUpResponseAdaptor;
import org.neo4j.causalclustering.catchup.TxPullRequestResult;
import org.neo4j.causalclustering.catchup.tx.PullRequestMonitor;
import org.neo4j.causalclustering.catchup.tx.TxPullRequest;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseListener;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.monitoring.Monitors;

public class TxPullClient {
    private final CatchUpClient catchUpClient;
    private PullRequestMonitor pullRequestMonitor;

    public TxPullClient(CatchUpClient catchUpClient, Monitors monitors) {
        this.catchUpClient = catchUpClient;
        this.pullRequestMonitor = (PullRequestMonitor)monitors.newMonitor(PullRequestMonitor.class, new String[0]);
    }

    public TxPullRequestResult pullTransactions(AdvertisedSocketAddress fromAddress, StoreId storeId, final long previousTxId, final TxPullResponseListener txPullResponseListener) throws CatchUpClientException {
        this.pullRequestMonitor.txPullRequest(previousTxId);
        return this.catchUpClient.makeBlockingRequest(fromAddress, new TxPullRequest(previousTxId, storeId), new CatchUpResponseAdaptor<TxPullRequestResult>(){
            private long lastTxIdReceived;
            {
                this.lastTxIdReceived = previousTxId;
            }

            @Override
            public void onTxPullResponse(CompletableFuture<TxPullRequestResult> signal, TxPullResponse response) {
                this.lastTxIdReceived = response.tx().getCommitEntry().getTxId();
                txPullResponseListener.onTxReceived(response);
            }

            @Override
            public void onTxStreamFinishedResponse(CompletableFuture<TxPullRequestResult> signal, TxStreamFinishedResponse response) {
                signal.complete(new TxPullRequestResult(response.status(), this.lastTxIdReceived));
            }
        });
    }
}

