/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.cursor.IOCursor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;

public class ChunkedTransactionStream
implements ChunkedInput<Object> {
    private final StoreId storeId;
    private final IOCursor<CommittedTransactionRepresentation> txCursor;
    private final CatchupServerProtocol protocol;
    private boolean endOfInput;
    private boolean noMoreTransactions;
    private long expectedTxId;
    private long lastTxId;
    private Object pending;

    ChunkedTransactionStream(StoreId storeId, long firstTxId, IOCursor<CommittedTransactionRepresentation> txCursor, CatchupServerProtocol protocol) {
        this.storeId = storeId;
        this.expectedTxId = firstTxId;
        this.txCursor = txCursor;
        this.protocol = protocol;
    }

    public boolean isEndOfInput() {
        return this.endOfInput;
    }

    public void close() throws Exception {
        this.txCursor.close();
    }

    public Object readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public Object readChunk(ByteBufAllocator allocator) throws Exception {
        assert (!this.endOfInput);
        if (this.pending != null) {
            if (this.noMoreTransactions) {
                this.endOfInput = true;
            }
            return this.consumePending();
        }
        if (this.noMoreTransactions) {
            throw new IllegalStateException();
        }
        if (this.txCursor.next()) {
            assert (this.pending == null);
            CommittedTransactionRepresentation tx = (CommittedTransactionRepresentation)this.txCursor.get();
            this.lastTxId = tx.getCommitEntry().getTxId();
            if (this.lastTxId != this.expectedTxId) {
                String msg = String.format("Transaction cursor out of order. Expected %d but was %d", this.expectedTxId, this.lastTxId);
                throw new IllegalStateException(msg);
            }
            ++this.expectedTxId;
            this.pending = new TxPullResponse(this.storeId, tx);
            return ResponseMessageType.TX;
        }
        assert (this.pending == null);
        this.noMoreTransactions = true;
        this.protocol.expect(CatchupServerProtocol.State.MESSAGE_TYPE);
        this.pending = new TxStreamFinishedResponse(CatchupResult.SUCCESS_END_OF_STREAM, this.lastTxId);
        return ResponseMessageType.TX_STREAM_FINISHED;
    }

    private Object consumePending() {
        Object prevPending = this.pending;
        this.pending = null;
        return prevPending;
    }

    public long length() {
        return -1L;
    }

    public long progress() {
        return 0L;
    }

    public long lastTxId() {
        return this.lastTxId;
    }
}

