/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.CatchupAddressResolutionException;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.storecopy.CommitState;
import org.neo4j.causalclustering.catchup.storecopy.CommitStateHelper;
import org.neo4j.causalclustering.catchup.storecopy.MaximumTotalTime;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StreamToDiskProvider;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.causalclustering.catchup.tx.TxPullClient;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RemoteStore {
    private final Log log;
    private final Config config;
    private final Monitors monitors;
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final LogProvider logProvider;
    private final StoreCopyClient storeCopyClient;
    private final TxPullClient txPullClient;
    private final TransactionLogCatchUpFactory transactionLogFactory;
    private final CommitStateHelper commitStateHelper;

    public RemoteStore(LogProvider logProvider, FileSystemAbstraction fs, PageCache pageCache, StoreCopyClient storeCopyClient, TxPullClient txPullClient, TransactionLogCatchUpFactory transactionLogFactory, Config config, Monitors monitors) {
        this.logProvider = logProvider;
        this.storeCopyClient = storeCopyClient;
        this.txPullClient = txPullClient;
        this.fs = fs;
        this.pageCache = pageCache;
        this.transactionLogFactory = transactionLogFactory;
        this.config = config;
        this.monitors = monitors;
        this.log = logProvider.getLog(this.getClass());
        this.commitStateHelper = new CommitStateHelper(pageCache, fs, config);
    }

    public CatchupResult tryCatchingUp(AdvertisedSocketAddress from, StoreId expectedStoreId, File storeDir, boolean keepTxLogsInDir, boolean forceTransactionLogRotation) throws StoreCopyFailedException, IOException {
        CommitState commitState = this.commitStateHelper.getStoreState(storeDir);
        this.log.info("Store commit state: " + commitState);
        if (commitState.transactionLogIndex().isPresent()) {
            return this.pullTransactions(from, expectedStoreId, storeDir, commitState.transactionLogIndex().get() + 1L, false, keepTxLogsInDir, forceTransactionLogRotation);
        }
        if (commitState.metaDataStoreIndex() == 1L) {
            return this.pullTransactions(from, expectedStoreId, storeDir, commitState.metaDataStoreIndex() + 1L, false, keepTxLogsInDir, forceTransactionLogRotation);
        }
        CatchupResult catchupResult = this.pullTransactions(from, expectedStoreId, storeDir, commitState.metaDataStoreIndex(), false, keepTxLogsInDir, forceTransactionLogRotation);
        if (catchupResult == CatchupResult.E_TRANSACTION_PRUNED) {
            return this.pullTransactions(from, expectedStoreId, storeDir, commitState.metaDataStoreIndex() + 1L, false, keepTxLogsInDir, forceTransactionLogRotation);
        }
        return catchupResult;
    }

    public void copy(CatchupAddressProvider addressProvider, StoreId expectedStoreId, File destDir, boolean rotateTransactionsManually) throws StoreCopyFailedException {
        try {
            StreamToDiskProvider streamToDiskProvider = new StreamToDiskProvider(destDir, this.fs, this.monitors);
            long lastFlushedTxId = this.storeCopyClient.copyStoreFiles(addressProvider, expectedStoreId, streamToDiskProvider, () -> new MaximumTotalTime(((Duration)this.config.get(CausalClusteringSettings.store_copy_max_retry_time_per_request)).getSeconds(), TimeUnit.SECONDS), destDir);
            this.log.info("Store files need to be recovered starting from: %d", new Object[]{lastFlushedTxId});
            CatchupResult catchupResult = this.pullTransactions(addressProvider.primary(), expectedStoreId, destDir, lastFlushedTxId, true, true, rotateTransactionsManually);
            if (catchupResult != CatchupResult.SUCCESS_END_OF_STREAM) {
                throw new StoreCopyFailedException("Failed to pull transactions: " + (Object)((Object)catchupResult));
            }
        }
        catch (IOException | CatchupAddressResolutionException e) {
            throw new StoreCopyFailedException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private CatchupResult pullTransactions(AdvertisedSocketAddress from, StoreId expectedStoreId, File storeDir, long fromTxId, boolean asPartOfStoreCopy, boolean keepTxLogsInStoreDir, boolean rotateTransactionsManually) throws IOException, StoreCopyFailedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public StoreId getStoreId(AdvertisedSocketAddress from) throws StoreIdDownloadFailedException {
        return this.storeCopyClient.fetchStoreId(from);
    }
}

