/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.IOException;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;

class DataSourceChecks {
    private DataSourceChecks() {
    }

    static boolean isTransactionWithinReach(long requiredTxId, CheckPointer checkpointer) {
        if (DataSourceChecks.isWithinLastCheckPoint(requiredTxId, checkpointer)) {
            return true;
        }
        try {
            checkpointer.tryCheckPoint((TriggerInfo)new SimpleTriggerInfo("Store file copy"));
            return DataSourceChecks.isWithinLastCheckPoint(requiredTxId, checkpointer);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isWithinLastCheckPoint(long atLeast, CheckPointer checkPointer) {
        return checkPointer.lastCheckPointedTransactionId() >= atLeast;
    }

    static boolean hasSameStoreId(StoreId storeId, NeoStoreDataSource dataSource) {
        return storeId.equalToKernelStoreId(dataSource.getStoreId());
    }
}

