/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.ArrayList;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.strategies.ConnectToRandomCoreServerStrategyTest;
import org.neo4j.causalclustering.upstream.strategies.TypicallyConnectToRandomReadReplicaStrategy;
import org.neo4j.causalclustering.upstream.strategies.UserDefinedConfigurationStrategyTest;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class TypicallyConnectToRandomReadReplicaStrategyTest {
    @Test
    public void shouldConnectToCoreOneInTenTimesByDefault() {
        MemberId theCoreMemberId = new MemberId(UUID.randomUUID());
        TopologyService topologyService = UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(theCoreMemberId), UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology(UserDefinedConfigurationStrategyTest.memberIDs(100)));
        Config config = (Config)Mockito.mock(Config.class);
        Mockito.when((Object)config.get(CausalClusteringSettings.database)).thenReturn((Object)"default");
        TypicallyConnectToRandomReadReplicaStrategy connectionStrategy = new TypicallyConnectToRandomReadReplicaStrategy(2);
        connectionStrategy.inject(topologyService, config, (LogProvider)NullLogProvider.getInstance(), null);
        ArrayList responses = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                responses.add(connectionStrategy.upstreamDatabase().get());
            }
            Assert.assertThat(responses, (Matcher)CoreMatchers.hasItem((Object)theCoreMemberId));
            responses.clear();
        }
    }
}

