/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import co.unruly.matchers.OptionalMatchers;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.strategies.ConnectRandomlyToServerGroupStrategy;
import org.neo4j.causalclustering.upstream.strategies.ConnectRandomlyToServerGroupStrategyImplTest;
import org.neo4j.causalclustering.upstream.strategies.UserDefinedConfigurationStrategyTest;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ConnectRandomlyToServerGroupStrategyTest {
    @Test
    public void shouldConnectToGroupDefinedInStrategySpecificConfig() {
        String targetServerGroup = "target_server_group";
        Config configWithTargetServerGroup = Config.defaults((Setting)CausalClusteringSettings.connect_randomly_to_server_group_strategy, (String)"target_server_group");
        Object[] targetGroupMemberIds = UserDefinedConfigurationStrategyTest.memberIDs(10);
        TopologyService topologyService = ConnectRandomlyToServerGroupStrategyImplTest.getTopologyService(Collections.singletonList("target_server_group"), (MemberId[])targetGroupMemberIds, Collections.singletonList("your_server_group"));
        ConnectRandomlyToServerGroupStrategy strategy = new ConnectRandomlyToServerGroupStrategy();
        strategy.inject(topologyService, configWithTargetServerGroup, (LogProvider)NullLogProvider.getInstance(), targetGroupMemberIds[0]);
        Optional result = strategy.upstreamDatabase();
        Assert.assertThat((Object)result, (Matcher)OptionalMatchers.contains((Matcher)Matchers.isIn((Object[])targetGroupMemberIds)));
    }
}

